# A5:SQL Mk-2

| 項目     | 内容                                                                                    |
| -------- | --------------------------------------------------------------------------------------- |
| ソフト名 | A5:SQL Mk-2 Version 2.21.0 beta 35                                                              |
| 制作者名 | 松原正和                                                                                |
| 動作環境 | x64版: Microsoft Windows Vista SP3, Windows 7 ~, Microsoft Windows Server 2008 R2 ~<br>x86版: Microsoft Windows XP ~, Microsoft Windows Server 2003 ~<br>※ x64版は 32bit OLE DB, ODBCには接続出来ません。<br>※ x86版は 64bit OLE DB, ODBCには接続出来ません。 |
| 種別     | ビジネス/データベース関連ソフトウェア                                                   |
| 連絡先   | 下記URLにアクセスしてトップページに記載されるメールアドレスにメールを送信してください。 |
| URL      | https://a5m2.mmatsubara.com/                                                            |

## 概要
A5:SQL Mk-2は複雑化するデータベース開発を支援するために開発されたフリーのSQL開発環境&ER図開発ツールです。  
高機能かつ軽量で、使い方が分かりやすいことを目標に開発されています。  
SQLを実行したり、テーブルを編集するほかに、SQLの実行計画を取得したり、ER図を作成したりするなど多彩な機能を持ちます。  

## ファイル
アーカイブファイルには以下のファイルが含まれます。

| ファイル名                | 説明                                                                                                             |
| ------------------------- | ---------------------------------------------------------------------------------------------------------------- |
| A5M2.exe                  | A5:SQL Mk-2 実行ファイル                                                                                         |
| A5M2.ENU                  | 英語言語リソース                                                                                                 |
| A5M2.drc                  | Delphi リソース文字列ファイル(Better Translation Manager 等で独自に言語リソースを作成する際に必要となるファイル) |
| a5er_specification.enu.md | ER図ファイルフォーマット(英語版)                                                                                 |
| a5er_specification.jpn.md | ER図ファイルフォーマット(日本語版)                                                                               |
| build_info.txt            | ビルドに使用されたコンパイラのバージョン情報                                                                     |
| concrt140.dll             | Microsoft Concurrency Runtime Library                                                                            |
| history.md                | 変更履歴                                                                                                         |
| libbson-1.0.dll           | libbson ライブラリ                                                                                               |
| libmongoc-1.0.dll         | MongoDB ライブラリ                                                                                               |
| license.md                | ライセンス定義ファイル                                                                                           |
| license_en.md             | ライセンス定義ファイル                                                                                           |
| msvc140.dll               | Microsoft C Runtime Library                                                                                      |
| picture.zip               | 各ボタン等のアイコンに使用される画像ファイルをまとめたZIPファイル                                                |
| readme.md                 | このファイル                                                                                                     |
| readme_en.md              | 英語版 readme                                                                                                    |
| sqlite3.dll               | SQLite ライブラリ                                                                                                |
| TileServerList.txt        | 地図のタイルサーバー情報                                                                                         |
| vcruntime140.dll          | Microsoft® C Runtime Library                                                                                     |
| VirusCheck.txt            | アンチウイルスソフトにおける各ファイルのチェック結果ファイル                                                     |
| WebView2Loader.dll        | WebView2 コンポーネント(Chromium ベース Edge にて地図表示を行うために使用)                                       |
| sampledb*                 | サンプルデータベース(Microsoft Access, ER図)                                                                     |
| sample*                   | 各種サンプル（スクリプト類）                                                                                     |
| scripts*                  | スクリプトファイル                                                                                               |
| geom_js*                  | leaflet, WKX                                                                                                     |

## OS、配布ファイル以外に必要なソフト
なし

## インストール
### ZIPファイル版
インストール作業は必要ありません。  
ZIPファイルを展開し、A5M2.exeを起動することで使用できます。  
ポータブルモード(後述)で利用する場合は、事前にA5M2.exeと同じフォルダに "Portable" フォルダを作成してから実行してください。  

### Microsoft Store版
[Microsoft Store](https://apps.microsoft.com/store/detail/a5sql-mk2-x64/9NSBB9XTJW86?hl=ja-jp&gl=jp)からインストールします。  


## アップグレード
### ZIPファイル版
インストールと同様にZIPファイルを展開し、A5M2.exeを起動することで使用できます。  
ZIPファイルの展開は古いバージョンとは別のフォルダに展開してください。  

### Microsoft Store版
Microsoft Storeからアップグレードします。

## アンインストール
### ZIPファイル x64版 または x64版(読み取り専用版)
ZIPファイルを展開したフォルダを削除します。  
レジストリエディタから`\\HKEY_CURRENT_USER\Software\mmatsubara\a5m2(x64)`を削除してください。  
`%APPDATA%\mmatsubara\a5m2(x64)` で表されるディレクトリ(%APPDATA%は環境変数)を削除してください。  
（ディレクトリ・レジストリの削除は必須ではありません）  
その後、A5M2.exeのあるフォルダを削除します。  

### ZIPファイル x86版 または x86版(読み取り専用版)
ZIPファイルを展開したフォルダを削除します。  
レジストリエディタから`\\HKEY_CURRENT_USER\Software\mmatsubara\a5m2(x86)`を削除してください。  
`%APPDATA%\mmatsubara\a5m2(x86)` で表されるディレクトリ(%APPDATA%は環境変数)を削除してください。  
（ディレクトリ・レジストリの削除は必須ではありません）  
その後、A5M2.exeのあるフォルダを削除します。  

### ポータブルモードで利用している場合
A5M2.exeのあるフォルダを削除します。  

※ ポータブルモードでなく、一度でも通常モードで起動したことがある場合は、【x86版・x86版(読み取り専用版)】または、【x64版・x64版(読み取り専用版)】に従ってアンインストール作業を行ってください。  

### Microsoft Store版
スタートメニューでA5:SQL Mk-2のアイコンを右クリックし、「アンインストール」を選択します。  

## 使用方法
初回起動時にデータベース登録画面が表示されます。そこから利用するデータベースを登録します。  
それが終わったら、左側のツリーより各データベースへ接続し、テーブル・ビュー・シノニム及びストアドプロシージャへアクセスできます。  
SQL(S) のメニューより新規作成を選ぶことでSQL文がテストできるようになります。このウインドウではselect文、やその他のDML文(Insert, Update, Delete)が実行できます。接続先のRDBMSが提供する構文でDDL文も実行可能です。  

以下に大まかな機能一覧を示します。  
- 様々なDBへの接続（Oracle, PostgreSQL, MySQL, SQLiteへは直接接続できます）
- SQL入力補完機能（共通表式やサブクエリも解析）
- SQLをGUIで作成・編集する機能
- 実行計画取得機能
- SQL整形機能
- ";" (セミコロン)または行頭の"/"(スラッシュ)や"GO"で区切ったSQLの連続実行
- 複数の結果セットをまとめて Excel へ出力
- SQLを２回実行して差を Excel へ出力（複数結果セットの比較も可能）
- パラメータを使ったSQLの実行
- テーブルやクエリー結果セットのフィルタリング（絞込み）
- クエリーのコメント中にカラム名や結果セットのタイトルなどを指定する擬似命令を埋め込む機能
- Excelと連携可能なテーブルエディタ
- テーブルのプロパティ（RDBMSごとの追加情報）を表示
- テーブルのソースを表示
- テーブル内容のエクスポート・インポート
- テーブルに大量のテスト用ダミーデータをインサートする機能
- ER図を作成する機能
- データベースからER図を作成する機能
- ER図からデータベースのDDLを作成する機能
- スクリプト言語機能
- AI(外部サービス)による自然文からSQL文を生成する機能
- AI(外部サービス)によるエラーになるSQL文を修正する機能
- AI(外部サービス)によるSQLのパフォーマンスチューニング機能

※AI無効化版はAI(外部サービス)に関連する機能は使用できません。

詳しくは以下のサイトを参照してください。
https://a5m2.mmatsubara.com/

## ポータブルモード
通常、A5:SQL Mk-2はレジストリ及び、`%APPDATA%\a5m2(x86)`（または `%APPDATA%\a5m2(x64)`）配下に設定や一時ファイルを保存しますが、あらかじめ、A5M2.exeと同じフォルダに "Portable" フォルダを作成しておくことで全ての設定および一時ファイル・SQLログファイルを "Portable" フォルダに配置するようになる「ポータブルモード」で動作させることができます。  
これにより、USBメモリなどに配置してA5:SQL Mk-2を持ち運び、各PCで設定を共有することができるようになります。  

ポータブルモードは以下の特徴を備えます。  
- レジストリに書き込みを行わない
- "Portable" フォルダ以外に一時ファイルを作成しない
- 設定や一時ファイル・SQLログファイルはすべてAES(256bit)で暗号化される
- 起動パスワードを設定することができる
- ファイルの関連付けは行えない

ポータブルモードは上述の通り、設定や一時ファイル・SQLログファイルをすべてAES(キー長:256bit)で暗号化します。このため、起動パスワードを設定すれば、万一A5:SQL Mk-2 の入ったUSBメモリ等を紛失しても、DBの設定情報や一時保存されたSQL・ER図・スクリプト、SQLの実行を記録したログファイルが流出する可能性を最小限にすることができます。  

もちろん、USBメモリ等に入れなくとも、レジストリに書き込みを行わない目的でポータブルモードを利用することもできます。  

Microsoft Store版はポータブルモードで利用できません。  

## 起動パラメータ
起動時にファイルを引数として渡すことでそのファイルを開くことができます。  
それ以外に以下のパラメータを処理することができます。  

- `/Workspace ‹WorkspaceName[:Portable]›`
  - 指定したワークスペースで起動します。
  - ポータブルモードのワークスペースを利用するときは、ワークスペース名の後ろに ":Portable" を付加します
- `/Connect <DBName>`
  - 指定されたデータベースに接続します。
- `/ConnectAs <UserName>/<Password>@<DBName>`
  - 指定されたデータベースに指定されたユーザー名・パスワードで接続します。
- `/AddDB <DBName>=<ConnectionString>`
  - データベースを登録します。
  - すでに `<DBName>` のデータベースが登録されている場合エラーとなります。
  - `/AddDB` パラメータを複数記述することで複数のデータベースを登録できます。
- `/SetDB <DBName>=<ConnectionString>`
  - データベースを登録します。
  - すでに `<DBName>` のデータベースが登録されている場合上書きされます。
  - `/SetDB` パラメータを複数記述することで複数のデータベースを登録できます。
- `/DelDB <DBName>`
  - データベースを登録解除します。
- `/DelAllDB`
  - 全てのデータベースを登録解除します。
- `/RestoreSession`
  - 前回終了時の状態を復元します。
  - 未指定時は「起動時に前回終了時のファイルの状態を復元する」のチェック状態に従います。
- `/NoRestoreSession`
  - 前回終了時の状態を復元しません。
  - 未指定時は「起動時に前回終了時のファイルの状態を復元する」のチェック状態に従います。
- `/Exit`
  - A5M2.exe を終了します。他の起動パラメータより後に指定する必要があります。
  - 起動パラメータの処理のみ行いたい場合に指定します。

## 利用しているプログラム部品について
A5:SQL Mk-2では以下のプログラム部品（コンポーネント・ライブラリ）を利用させていただいております。作者の皆様に心より感謝いたします。  
- ActiveQueryBuilder Ver 1.17
  - Active Database Software
  - Commercial License
- DCPcrypt 2017-12-16(r16)
  - https://sourceforge.net/projects/dcpcrypt/
  - Copyright © 1999-2009 David Barton
  - 提供: lomo74
  - MIT License
    - https://a5m2.mmatsubara.com/open_source_license/DCPcrypt/MIT_license.txt
    - https://opensource.org/licenses/mit-license.php
- DMonkey Version: 0.3.9.1
  - Project DMonkey
  - 独自ライセンス
- GDI+ API, GDI+ Class, GDI+ Util
  - http://www.progdigy.com
  - Mozilla Public License Version 1.1
  - ソース : https://github.com/m-matsubara/GDIPlus_Delphi
- github-markdown-css
  - Copyright (c) Sindre Sorhus &lt;sindresorhus@gmail.com&gt; (https://sindresorhus.com)
  - https://github.com/sindresorhus/github-markdown-css
  - MIT License
- highlight.js
  - Copyright (c) 2006, Ivan Sagalaev.
  - https://highlightjs.org/
  - BSD-3-Clause license
- leaflet 1.7.1
  - © 2010–2021 Vladimir Agafonkin. Maps © OpenStreetMap contributors.
  - https://leafletjs.com/
  - BSD-2-Clause
- marked.js
  - Copyright (c) 2011-2022, Christopher Jeffrey. (MIT License)
  - https://github.com/markedjs/marked
  - MIT license
- MongoDB C クライアントライブラリ(DLL)
  - https://github.com/mongodb/mongo-c-driver
  - Apache License : https://www.apache.org/licenses/LICENSE-2.0
- range-regex
  - https://github.com/voronind/range-regex
  - Copyright (c) 2013, Dmitry Voronin
  - BSD-2-Clause License
  - 上述のコード(Python)をDelphi向けに変換して使用
    - https://github.com/m-matsubara/range-regex-pas
- SecureBridge Ver 11.0.1
  - Devart
  - Commercial License
- SQLite3.dll version 3.50.4
  - D. Richard Hipp
  - Public domain
- SynEdit
  - https://github.com/m-matsubara/SynEdit
  - forked from https://github.com/pyscripter/SynEdit
  - forked from https://github.com/TurboPack/SynEdit
  - original https://github.com/SynEdit/SynEdit
  - Mozilla Public License Version 1.1
    - ※ ブランチについて
      - x64版は m-matsubara/SynEdit の mm_develop ブランチを使用
      - x86版は m-matsubara/SynEdit の mm_develop_gdi ブランチを使用
- TCtrlGridコンポーネント Ver 2.10
  - ＳＵＮ
- UniDAC Ver 11.0.0
  - Devart
  - Commercial License
- WKX
  - Copyright (c) 2013 Christian Schwarz
  - https://github.com/cschwarz/wkx
  - MIT License
    - https://a5m2.mmatsubara.com/open_source_license/DCPcrypt/MIT_license.txt
    - https://opensource.org/licenses/mit-license.php
- フォント名コンボボックス(＆リストボックス) Version 1.2.1
  - CQN11335 加藤太朗
