# A5:SQL Mk-2 ER Diagram File Format Specification (Version 2.21)

## 1. Overview

This document specifies the format for `.a5er` ER Diagram files used by the database client tool A5:SQL Mk-2.

This is a text-based file with a structure similar to an INI file. The character encoding is **UTF-8 (with BOM)**.

Each setting is represented by a `key=value` pair, and each object that constitutes the ER diagram (such as entities and relations) is separated by a `[SectionName]`.

### 1.1. Basic Structure

The file consists of the following elements:

1.  **Header Comments**: Indicates the file type and version information. Lines starting with `#` are treated as comments.
2.  **`[Manager]` Section**: Defines global settings for the entire ER diagram.
3.  **Object Sections**: Definitions for each object composing the ER diagram (entities, relationships, etc.) follow.

Below is a sample:

```ini
# A5:ER FORMAT:21
# A5:ER ENCODING:UTF8
# ... (Other header comments)

[Manager]
PageInfo="Main",3,"A3Landscape",$FFFFFF

[Entity]
PName=users
LName=Users
Field="User ID","id","Serial","NOT NULL",0,"","",$FFFFFFFF,""
Field="Username","user_name","varchar(100)","NOT NULL",,"","",$FFFFFFFF,""
Field="Birthday","birthday","date","NOT NULL",,"","",$FFFFFFFF,""
Index=users_ix1=0,user_name,birthday
Position="MAIN",2350,800

[Entity]
PName=orders
LName=Orders
Field="Order ID","id","Serial","NOT NULL",0,"","",$FFFFFFFF,""
Field="User ID","user_id","Integer","NOT NULL",,"","",$FFFFFFFF,""
Position="MAIN",5000,800

[Relation]
Entity1=users
Entity2=orders
Fields1=id
Fields2=user_id
RelationType1=2
RelationType2=3
Position="MAIN",0,5000,5000,5000,R,R,""
```

*Note: When outputting from A5:SQL Mk-2, additional items may be included for compatibility with the past.*

### 1.2. Value Formats

  - **String**: Represents any string.  
  - **EscapedString**: Represents any string. It is escaped according to the rules described below.  
  - **Boolean**: Represented by `1` (True) or `0` (False).  
  - **Color**: Represented in hexadecimal format as `$AABBGGRR` or `$BBGGRR` (e.g., `$000000`, `$FF000000`). The top two digits are not for the alpha channel, and `$FFFFFFFF` may represent the default color.  
  - **Complex**: Multiple values are written on a single line, separated by commas. String values are enclosed in double quotes and escaped according to the rules described below.  

Strings in EscapedString and Complex are escaped according to the following rules:

| Character | Escaped Representation |
|-----------|------------------------|
| \\        | \\\\                   |
| "         | \\Q                    |
| '         | \\q                    |
| Tab       | \\t                    |
| Newline   | \\n                    |

-----

## 2. Header Comments

Comments may be written at the beginning of the file.

While these are fundamentally comments and the file will work without them, A5:SQL Mk-2 uses them to determine if a file was saved in a different version and as a reference for file encoding.  
(Normally, only **UTF-8 (with BOM)** is used for file encoding. The use of other encodings is not recommended.)

| Item               | Description                                | Example                 |
|--------------------|--------------------------------------------|-------------------------|
| `# A5:ER FORMAT`   | File format number.                        | `# A5:ER FORMAT:21`     |
| `# A5:ER ENCODING` | Character encoding of the file.            | `# A5:ER ENCODING:UTF8` |

The correspondence between A5:SQL Mk-2 versions and A5:ER FORMAT version numbers is as follows:

| A5:SQL Mk-2 Version | File Format Number |
|---------------------|--------------------|
| Version 2.1         | 1                  |
| Version 2.2         | 2                  |
| Version 2.3         | 3                  |
| Version 2.4         | 4                  |
| Version 2.5         | 4                  |
| Version 2.6         | 5                  |
| Version 2.7         | 6                  |
| Version 2.8         | 7                  |
| Version 2.9         | 8                  |
| Version 2.10        | 9                  |
| Version 2.11        | 10                 |
| Version 2.12        | 11                 |
| Version 2.13        | 12                 |
| Version 2.14        | 13                 |
| Version 2.15        | 14                 |
| Version 2.16        | 15                 |
| Version 2.17        | 16                 |
| Version 2.18        | 17                 |
| Version 2.19        | 18                 |
| Version 2.20        | 19                 |
| Version 2.21        | 21                 |

-----

## 3. `[Manager]` Section

### 3.1. Global Settings for the Entire ER Diagram

Basic Items

| Item                                 | Type          | Required  | Default   | Description                                                                                                                                                                         |
|--------------------------------------|---------------|-----------|-----------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ProjectName`                        | EscapedString |           |           | Project name.                                                                                                                                                                       |
| `Author`                             | EscapedString |           |           | Author name.                                                                                                                                                                        |
| `MaxEntityRowShow`                   | Integer       |           | `1000`    | Maximum number of attribute rows to display for an entity. (If exceeded, the display is truncated at that number of rows and a message like "\<continued\>" is shown.)              |
| `ReadOnlyRecommend`                  | Boolean       |           | `0`       | `1`: Recommends opening in read-only mode.                                                                                                                                          |
| `Comment`                            | EscapedString |           |           | Comments about the project.                                                                                                                                                         |
| `PageInfo`                           | Complex       | 1 or more |           | **[Complex Value]** Information about the pages **(can be specified multiple times per page)**. See below.                                                                          |
| `DomainInfo`                         | Complex       |           |           | **[Complex Value]** Information about domains (data type templates) **(can be specified multiple times per domain)**. See below.                                                    |
| `LogicalView`                        | Boolean       |           | `0`       | `1`: Display logical names, `0`: Display physical names.                                                                                                                            |
| `DecodeDomain`                       | Boolean       |           | `0`       | `0`: No decoding, `1`: Decode only user-defined domains, `2`: Decode user-defined and system-defined domains.                                                                       |
| `ViewFormat`                         | Integer       |           | `0`       | Display format `0`: IE, `1`: IDEF1X.                                                                                                                                                |
| `UseNondependenceDashLine`           | Boolean       |           | `0`       | `0`: Use solid lines for non-identifying relationships, `1`: Use dashed lines.                                                                                                      |
| `FontName`                           | String        |           | `Tahoma`  | Default font name to use in the ER diagram.                                                                                                                                         |
| `FontSize`                           | Float         |           | `9.0`     | Default font size.                                                                                                                                                                  |
| `HeaderLeft`                         | String        |           |           | String to be printed on the left side of the page header.                                                                                                                           |
| `HeaderCenter`                       | String        |           |           | String to be printed in the center of the page header.                                                                                                                              |
| `HeaderRight`                        | String        |           |           | String to be printed on the right side of the page header.                                                                                                                          |
| `FooterLeft`                         | String        |           |           | String to be printed on the left side of the page footer.                                                                                                                           |
| `FooterCenter`                       | String        |           |           | String to be printed in the center of the page footer.                                                                                                                              |
| `FooterRight`                        | String        |           |           | String to be printed on the right side of the page footer.                                                                                                                          |
| `ShowPageoutRelation`                | Boolean       |           | `1`       | Whether to draw the existence of relationships that span two pages.                                                                                                                 |
| `ShowTag`                            | Boolean       |           | `1`       | Whether to display tags.                                                                                                                                                            |
| `ShowCommonAttributes`               | Boolean       |           | `0`       | Whether to display common attributes.                                                                                                                                               |
| `BugFixEntityWidth`                  | Boolean       |           | `1`       | `1`: Fixes the entity width calculation logic. The current version always outputs 1. If `0`, automatic calculation of entity width may not work correctly.                          |
| `CommonField`                        | Complex       |           |           | **[Complex Value]** Information about common columns **(can be specified multiple times per common column)**. See below.                                                            |

DDL Generation Related Items

| Item                                 | Type    | Required | Default           | Description                                                                                                                                                                                                                                 |
|--------------------------------------|---------|----------|-------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `RDBMSTypeName`                      | String  |          | `Oracle Database` | Name of the target RDBMS. (`Oracle Database`, `IBM Db2`, `Microsoft SQL Server 2000`, `Microsoft SQL Server 2005`, `Microsoft SQL Server 2008`, `Microsoft SQL Server 2016`, `MySQL`, `PostgreSQL`)                                         |
| `GenerateComment`                    | Boolean |          | `1`               | `1`: Generate comments for `CREATE TABLE` statements and their columns.                                                                                                                                                                     |
| `GenerateDropTableStatement`         | Boolean |          | `0`               | `1`: Generate `DROP TABLE` statements.                                                                                                                                                                                                      |
| `DropTableIfExists`                  | Boolean |          | `0`               | `1`: Add the `IF EXISTS` option to `DROP TABLE` statements (only for PostgreSQL, SQL Server 2016, and MySQL).                                                                                                                               |
| `BackupRestoreTempTable`             | Boolean |          | `1`               | `1`: Add the `BackupToTempTable` pseudo-command to `DROP TABLE` statements and the `RestoreFromTempTable` pseudo-command to `CREATE TABLE` statements (A5:SQL Mk-2's proprietary feature to back up and restore data to a temporary table). |
| `ForceQuoteIdentifier`               | Boolean |          | `0`               | `1`: Always enclose identifiers in quotes.                                                                                                                                                                                                  |
| `EnableTableOption`                  | Boolean |          | `1`               | `1`: Append specified table options to the DDL.                                                                                                                                                                                             |
| `CreatePkIndex`                      | Boolean |          | `0`               | `1`: For primary key fields, create an index first, then assign the primary key with `ALTER TABLE`.                                                                                                                                         |
| `CreateFk`                           | Boolean |          | `0`               | `1`: Generate foreign key constraints.                                                                                                                                                                                               |
| `FkOnDeleteOption`                   | String  |          |                   | Option for foreign key on delete (e.g., `CASCADE`). The `ON DELETE` prefix is optional.                                                                                                                                                        |
| `FkOnUpdateOption`                   | String  |          |                   | Option for foreign key on update (e.g., `NO ACTION`, `CASCADE`, `SET NULL`, `SET DEFAULT`). The `ON UPDATE` prefix is optional.                                                                                                                |
| `CreateFK_ParentCard1Only`           | Boolean |          | `0`               | `1`: Generate a foreign key only if the parent side of the relationship has a cardinality of 1.                                                                                                                                                |
| `FKParentIndex`                      | Boolean |          | `0`               | `1`: Create an index on the parent side of the foreign key (if one does not already exist). Used when the parent side is not a primary key.                                                                                                      |
| `GenerateCommentStatement`           | Boolean |          | `1`               | `1`: Generate comment statements for tables/columns.                                                                                                                                                                                 |
| `GenerateCommentStatement_LName`     | Boolean |          | `1`               | `1`: Include the object's logical name in the comment statement.                                                                                                                                                                     |
| `GenerateCommentStatement_Comment`   | Boolean |          | `1`               | `1`: Include the object's comment in the comment statement.                                                                                                                                                                          |
| `GenerateCommentStatement_Separator` | String  |          | `:`               | The separator string used when both the logical name and comment are included in the comment statement.                                                                                                                                        |
| `DefaultPkName`                      | String  |          | `%0:s_PKC`        | Default format for primary key constraint names. (`%s`, `%0:s` are replaced with the entity's physical name).                                                                                                                                  |
| `DefaultPkIndexName`                 | String  |          | `%0:s_PKI`        | Default format for primary key index names. (`%s`, `%0:s` are replaced with the entity's physical name).                                                                                                                                       |
| `DefaultIndexName`                   | String  |          | `%0:s_IX%1:d`     | Default format for non-primary key index names. (`%s`, `%0:s` are replaced with the entity's physical name. `%d`, `%1:d` are replaced with the index number).                                                                                      |
| `DefaultFkName`                      | String  |          | `%0:s_FK%1:d`     | Default format for foreign key constraint names. (`%s`, `%0:s` are replaced with the entity's physical name. `%d`, `%1:d` are replaced with the index number).                                                                                      |
| `SqlSeparator`                       | Integer |          | `0`               | SQL statement separator. `0`: Semicolon, `1`: A line containing only `/`, `2`: A line containing only `GO`.                                                                                                                                     |
| `UpperCaseKeyword`                   | Boolean |          | `0`               | `1`: Capitalize keywords.                                                                                                                                                                                                                      |
| `CreateOrder`                        | String  |          | `Default`         | `CREATE TABLE` order: `Default`, `PName`, `LName`, `Tag`, `Dependent`. `Default` generates based on diagram placement, starting with objects placed first (further back).                                                                        |

*Note: The items `Page`, `Domain`, `ViewModePageIndividually`, `ViewMode`, `PaperSize`, and `RDBMSType` are also output but are older items for compatibility and can be ignored.*

### 3.1.1. Header and Footer Strings

The following string substitutions are performed for `HeaderLeft`, `HeaderCenter`, `HeaderRight`, `FooterLeft`, `FooterCenter`, and `FooterRight`.

| Original String   | Substituted String             |
|-------------------|--------------------------------|
| %FileName%        | File name (without path)       |
| %PageCount%       | Total number of pages          |
| %PageNo%          | Page number                    |
| %PageName%        | Page name                      |
| %Date%            | Date                           |
| %Time%            | Time                           |
| %ProjectName%     | Project name                   |
| %Author%          | Author name                    |
| %%                | `%`                            |

  - **Example**: `FooterCenter=%PageNo%/%PageCount%`

### 3.1.2. Page Settings (Complex Value)

Page information is stored under the `PageInfo` key. At least one `PageInfo` entry is required in an ER diagram. The page name specified in the properties of each object must match a page name defined in the `PageInfo` entry. Entities that do not fit on a single page can be divided among pages, or sub-models can be created on separate pages.

  - **`PageInfo`**: Defines detailed page information.  
    - **Format**: `"PageName",DisplayMode,"PaperSize","BackgroundColor"`  
      - `PageName`: The name of the page. Must be unique across pages, case-insensitive.  
      - `DisplayMode`: `0`: Entity, `1`: Primary Key, `2`: Attributes, `3`: Attributes and Data Type, `4`: Attributes and Data Type with alignment, `5`: Attributes' Logical/Physical Names, `6`: Attributes' Logical/Physical Names and Data Type, `7`: Attributes' Logical/Physical Names and Data Type with alignment.  
      - `PaperSize`: A string combining a paper size (`A4` to `A1`, `B4` to `B2`) and orientation (`Landscape`, `Portrait`). Examples: `A4Landscape`, `A4Portrait`, `A3Landscape`.  
      - `BackgroundColor`: `$BBGGRR` format.  

  - **Example**: `PageInfo="Main",3,"A3Landscape",$FFFFFF`

*Note: String items are enclosed in double quotes.*
*Note: Of the drawing area specified by the paper size, the top, bottom, left, and right 5mm are treated as margins. The positions of objects like entities are specified in 0.1mm units within the area excluding these margins.*

### 3.1.3. Domain Settings

User-defined domains (data type templates) can be stored under the `DomainInfo` key.

  - **Format**: `"DomainName","DataType","Comment","ColumnPhysicalName"`  
      - `DomainName`: The name of the domain. Must be unique across domains, case-insensitive.  
      - `DataType`: The data type, or a user-defined/system-defined domain name.  
      - `Comment`: The domain's comment.  
      - `ColumnPhysicalName`: The default column physical name to be used when the domain is specified for an entity, but the name is not enforced.  

  - **Example**: `DomainInfo="ID","INTEGER","Unique ID","id"`

The `DataType` can also be a `system-defined domain` starting with `@`, which are pre-defined by the system.

| System-Defined Domain | Meaning                     |
|-----------------------|-----------------------------|
| @VARCHAR              | Variable-length string      |
| @CHAR                 | Fixed-length string         |
| @DECIMAL              | Numeric type                |
| @INT                  | Integer type                |
| @FLOAT                | Single-precision float type |
| @DOUBLE               | Double-precision float type |
| @DATE                 | Date type                   |
| @TIME                 | Time type                   |
| @DATETIME             | Date/time type              |
| @BOOLEAN              | Boolean type                |

These system-defined domains generate the appropriate DDL based on the selected relational database type.

### 3.1.4. Common Column Settings

Common column settings are stored under the `CommonField` key.

  - **Format**: `"CommonColumnLogicalName","CommonColumnPhysicalName","DataType","NOT NULL",KeyOrder,"DefaultValue","Comment",Color`  
    - `CommonColumnLogicalName`: Logical name of the common column.  
    - `CommonColumnPhysicalName`: Physical name of the common column. Must be unique across common columns, case-insensitive.  
    - `DataType`: The data type, or a user-defined/system-defined domain name.  
    - `NOT NULL`: This string if `NotNull`, otherwise empty.  
    - `KeyOrder`: A 0-based index if it's a primary key, otherwise empty.  
    - `DefaultValue`: An expression representing the default value. Empty if not a primary key.  
    - `Comment`: Comment.  
    - `Color`: **`$AARRGGBB`** format. However, if `AA` is not the alpha channel, `$FFFFFFFF` represents the default color.  

  - **Example**: `CommonField="削除日時","deleted_at","timestamp",,,,"This column is considered logically deleted if not NULL.",$FFFFFFFF`

The `DataType` can also be a `system-defined domain` starting with `@`, which are pre-defined by the system.

| System-Defined Domain | Meaning                     |
|-----------------------|-----------------------------|
| @VARCHAR              | Variable-length string      |
| @CHAR                 | Fixed-length string         |
| @DECIMAL              | Numeric type                |
| @INT                  | Integer type (32bit)        |
| @FLOAT                | Single-precision float type |
| @DOUBLE               | Double-precision float type |
| @DATE                 | Date type                   |
| @TIME                 | Time type                   |
| @DATETIME             | Date/time type              |
| @BOOLEAN              | Boolean type                |

These system-defined domains generate the appropriate DDL based on the selected relational database type.

-----

## 4. Object Sections

### 4.1. `[Entity]`

Defines an entity (table).

A single object can be placed on multiple pages.

| Item                 | Type          | Required  | Default   | Description                                                                                                    |
|----------------------|---------------|-----------|-----------|----------------------------------------------------------------------------------------------------------------|
| `PName`              | String        | Required  |           | Physical name (table name). Must be unique across all objects in the ER diagram.                               |
| `LName`              | String        |           |           | Logical name.                                                                                                  |
| `Comment`            | EscapedString |           |           | Comment for the entity.                                                                                        |
| `TableInnerOption`   | EscapedString |           |           | Options appended inside the parentheses of the `CREATE TABLE` statement.                                       |
| `TableOption`        | EscapedString |           |           | Options appended at the end of the `CREATE TABLE` statement.                                                   |
| `Field`              | Complex       |           |           | **[Complex Value]** Attribute (column) definition **(can be specified multiple times per column)**. See below. |
| `IndexInfo`          | Complex       |           |           | **[Complex Value]** Index definition **(can be specified multiple times per index)**. See below.               |
| `NoDDL`              | Boolean       |           | `0`       | `1`: Exclude from DDL generation.                                                                              |
| `UsingCommonColumns` | Boolean       |           | `1`       | `1`: Use common attributes.                                                                                    |
| `EffectMode`         | String        |           | `None`    | Background effect. `None`, `Gradation`.                                                                        |
| `Tag`                | String        |           |           | Tags to apply to the entity. (Tags are freely specified by the user to denote entity types and have no specific meaning within A5:SQL.) |
| `Color`              | Color         |           | `$000000` | Foreground color. `$BBGGRR` format.                                                                            |
| `BkColor`            | Color         |           | `$FFFFFF` | Background color. `$BBGGRR` format.                                                                            |
| `ModifiedDateTime`   | String        |           |           | String in `YYYYMMDDhhmmss` format representing the last modified date and time.                                |
| `Position`           | Complex       | 1 or more |           | **[Complex Value]** Drawing information for each page **(multiple key items)**. See below.                     |
| `ZOrder`             | Integer       |           |           | The stacking order of the object. A higher value means it's in front.                                          |

*Note: The items `Page`, `Left`, `Top`, `Index`, and `IndexOption` are also output but are older items for compatibility and can be ignored.*

#### 4.1.1. `Field` (Complex Value)

  - **Format**: `"LogicalName","PhysicalName","DataType","NOT NULL",KeyOrder,"DefaultValue","Comment",Color,"Option","ExtraOption"`  
    - `LogicalName`: Logical name of the column.  
    - `PhysicalName`: Physical name of the column.  
    - `DataType`: The data type, or a user-defined/system-defined domain name.  
    - `NOT NULL`: `"NOT NULL"` if not nullable, otherwise empty.  
    - `KeyOrder`: A 0-based index(Integer) if it's a primary key, otherwise empty.  
    - `DefaultValue`: An expression representing the default value. Empty if not a primary key.  
    - `Comment`: Comment.  
    - `Color` (Required): **`$AARRGGBB`** format. However, if `AA` is not the alpha channel, `$FFFFFFFF` represents the default color.  
    - `Option`: A string appended to the end of the column definition during DDL generation.  
    - `ExtraOption`: If the column is disabled, this contains `"DISABLE"`. (Future versions may include other comma-separated strings.)  

  - **Example**: `Field="ユーザーID","id","INTEGER","NOT NULL",0,"","Unique ID for the user",$FFFFFFFF,"",""`

*Note: String items are enclosed in double quotes.*

#### 4.1.2. `IndexInfo` (Complex Value)

  - **Format**: `"IndexName",UniqueFlag,"ColumnList","IndexOption"`

      - `IndexName`: The name of the index.
      - `UniqueFlag`: `0`: Non-unique, `1`: Unique, `2`: Unique constraint.
      - `ColumnList`: A comma-separated list of column names.
      - `IndexOption`: Options for the index, appended to the end of the `CREATE INDEX` statement.

  - **Example**: `IndexInfo="users_ix1",0,"user_name,birthday", ""`

*Note: Some items are enclosed in double quotes.*

#### 4.1.3. `Position` (Complex Value)

  - **Format**: `"PageName",X-coordinate,Y-coordinate,Width,Height`  
      - `PageName`: Specifies the page name defined in the `[Manager]` section.  
      - `X-coordinate`: X-coordinate in 0.1mm units (must be within the paper size minus 1.0cm. For A3Landscape, less than 4100 is recommended, considering object width).  
      - `Y-coordinate`: Y-coordinate in 0.1mm units (must be within the paper size minus 1.0cm. For A3Landscape, less than 2870 is recommended, considering object height).  
      - `Width` and `Height`: Are only output if the size is fixed. They are not output when automatically calculated.  
      - Units for numbers are 0.1mm.  

  - **Example (without width/height)**: `Position="Main",100,500`

  - **Example (with width/height)**: `Position="Main",100,500,400,900`

*Note: String items are enclosed in double quotes.*

### 4.2. `[Relation]` / `[Relationship]`

Defines a relationship between entities.

| Item                 | Type    | Required | Default   | Description                                                                                                   |
|----------------------|---------|----------|-----------|---------------------------------------------------------------------------------------------------------------|
| `Entity1`, `Entity2` | String  | Required |           | Physical names of the parent (1) and child (2) entities.                                                      |
| `Fields1`, `Fields2` | String  | Required |           | Physical names of the related columns for the parent (1) and child (2) (comma-separated).                     |
| `RelationType1`      | Integer | Required | `1`       | Cardinality. `0`: Unspecified, `1`: 0 or 1, `2`: 1, `3`: 0 or more, `4`: 1 or more, `5`: fixed N.             |
| `RelationType2`      | Integer | Required | `3`       | Cardinality. `0`: Unspecified, `1`: 0 or 1, `2`: 1, `3`: 0 or more, `4`: 1 or more, `5`: fixed N.             |
| `Cardinarity1`       | String  |          |           | Cardinality string for IDEF1X display (e.g., "P", "Z").                                                       |
| `Cardinarity2`       | String  |          |           | Cardinality string for IDEF1X display (e.g., "P", "Z").                                                       |
| `Dependence`         | Boolean |          | `0`       | `1`: Dependent relationship.                                                                                  |
| `Caption`            | String  |          |           | Verb phrase. Text displayed in the center of the relationship.                                                |
| `PName`              | String  |          |           | Physical name of the foreign key constraint.                                                                  |
| `NoDDL`              | Boolean |          | `0`       | `1`: Exclude from DDL generation.                                                                             |
| `LineColor`          | Color   |          | `$000000` | Line color. `$BBGGRR` format.                                                                                 |
| `Position`           | Complex |          |           | Drawing information for each page **(multiple key items)**. See below.                                        |
| `ZOrder`             | Integer |          |           | The stacking order of the object. A higher value means it's in front.                                         |
| `ModifiedDateTime`   | String  |          |           | String in `YYYYMMDDhhmmss` format representing the last modified date and time.                               |

*Note: The items `LineMode`, `Bar1`, `Bar2`, `Bar3`, `TermPos1`, and `TermPos2` are also output but are older items for compatibility and can be ignored.*

#### 4.2.1. `Position` (Complex Value)

  - **Format**: `"PageName",LineMode,LinePos1,LinePos2,LinePos3,TermPos1,TermPos2,"VertexCoordinateList"`  
    - `LineMode` (Required): Line drawing mode (`0`: Auto, `1`: Vertical-Horizontal-Vertical, `2`: Horizontal-Vertical-Horizontal, `3`: Vertical-Horizontal, `4`: Horizontal-Vertical, `5`: (⊐) shape, `6`: (⊏) shape, `7`: Straight (Auto), `8`: Straight (Vertical Terminus), `9`: Straight (Horizontal Terminus), `10`: Free-form).  
    - `LinePos1-3` (Required): Parameters (0-10000) that determine the position of the line's bends. A value closer to 0 means the bend is at the top or left, while a value closer to 10000 means it's at the bottom or right.  
    - `TermPos1-2` (Required): Terminal orientation for relationships spanning different pages (`R`, `L`).  
    - `VertexCoordinateList`: List of vertex coordinates for free-form connections (separated by `;`).  

  - **Example**: `Position="Main",0,5000,5000,5000,R,R,""`

*Note: String items are enclosed in double quotes.*

### 4.3. `[View]`

Defines a view. It shares many items with the `[Entity]` section but does not have `Field` or `Index` items.

A single object can be placed on multiple pages.

| Item                 | Type    | Required  | Default | Description                                                                     |
|----------------------|---------|-----------|---------|---------------------------------------------------------------------------------|
| `PName`              | String  | Required  |         | Physical name (view name). Must be unique across all objects in the ER diagram. |
| `LName`              | String  |           |         | Logical name.                                                                   |
| `Comment`            | String  |           |         | Comment for the entity.                                                         |
| `Query`              | String  |           |         | The `SELECT` statement that defines the view.                                   |
| `LNameByComment`     | Boolean |           | `0`     | `1`: Treat comments in the `SELECT` statement as column logical names.          |
| `MaterializedView`   | Boolean |           | `0`     | `1`: Treat as a materialized view.                                              |
| `NoDDL`              | Boolean |           | `0`     | `1`: Do not generate DDL.                                                       |
| `Color`              | Color   |           |         | Foreground color. `$BBGGRR` format.                                             |
| `BkColor`            | Color   |           |         | Background color. `$BBGGRR` format.                                             |
| `ModifiedDateTime`   | String  |           |         | String in `YYYYMMDDhhmmss` format representing the last modified date and time. |
| `Position`           | String  | 1 or more |         | Common properties with the `[Entity]` section.                                  |
| `ZOrder`             | Integer |           |         | The stacking order of the object. A higher value means it's in front.           |
| `EffectMode`         | String  |           | `None`  | Background effect. `None`, `Gradation`.                                         |

*Note: The items `Page`, `Left`, and `Top` are also output but are older items for compatibility and can be ignored.*

### 4.4. `[Subtype]`

Defines a subtype.

A single object can be placed on multiple pages.

| Key                  | Type    | Required  | Default | Description                                                                                    |
|----------------------|---------|-----------|---------|------------------------------------------------------------------------------------------------|
| `PName`              | String  | Required  |         | Physical name (automatically determined). Must be unique across all objects in the ER diagram. |
| `SharedMode`         | Boolean |           | `0`     | `1`: Shared mode (the subtype symbol in IE notation becomes `X`), `0`: Exclusive mode.         |
| `CompleteCategory`   | Boolean |           | `0`     | `1`: Complete category for IDEF1X notation (becomes a double circle), `0`: Incomplete.         |
| `Position`, `ZOrder` | -       | 1 or more |         | Common properties with the `[Entity]` section.                                                 |

### 4.5. `[Shape]`

Defines a shape such as a rectangle, circle, or arrow.

Placed on a single page.

| Key             | Type    | Required | Default   | Description                                                                                                                                                                                                                                                                                       |
|-----------------|---------|----------|-----------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `Page`          | String  | Required |           | Page name.                                                                                                                                                                                                                                                                                        |
| `Left`          | Integer | Required |           | Left position (in 0.1mm units).                                                                                                                                                                                                                                                                   |
| `Top`           | Integer | Required |           | Top position (in 0.1mm units).                                                                                                                                                                                                                                                                    |
| `Width`         | Integer | Required |           | Width (in 0.1mm units).                                                                                                                                                                                                                                                                           |
| `Height`        | Integer | Required |           | Height (in 0.1mm units).                                                                                                                                                                                                                                                                          |
| `ZOrder`        | Integer |          |           | The stacking order of the object. A smaller value means it's in the back, a larger value means it's in the front.                                                                                                                                                                                 |
| `ShapeType`     | String  | Required |           | Type of shape. `Rectangle`, `RoundRect` (rounded rectangle), `Ellipse`, `Round` (circle), `Cross`, `StickMan`, `AllowUpper` (up arrow), `AllowLower` (down arrow), `AllowLeft` (left arrow), `AllowRight` (right arrow), `Database` (drum-like), `Mail` (envelope-like), `Window` (GUI window).   |
| `LineColor`     | Color   |          | `$000000` | Line color. `$BBGGRR` format.                                                                                                                                                                                                                                                                     |
| `LineWidth`     | Integer |          |           | Line thickness. `$BBGGRR` format.                                                                                                                                                                                                                                                                 |
| `LineType`      | Integer |          | `0`       | Type of line. `0`: Solid, `1`: None, `2`: Dash, `3`: Dash-dot, `4`: Dash-dot-dot.                                                                                                                                                                                                                 |
| `BrushColor`    | Color   |          | `$FFFFFF` | Fill color. `$BBGGRR` format.                                                                                                                                                                                                                                                                     |
| `BrushAlpha`    | Integer |          | `255`     | Fill opacity (0-255).                                                                                                                                                                                                                                                                             |
| `RoundRectR`    | Integer |          |           | Corner radius for `RoundRect` (in 0.1mm units).                                                                                                                                                                                                                                                   |
| `Text`          | String  |          |           | Text to display within the shape.                                                                                                                                                                                                                                                                 |
| `FontName`      | String  |          | `Tahoma`  | Font name.                                                                                                                                                                                                                                                                                        |
| `FontSize`      | Float   |          | `9.0`     | Default font size.                                                                                                                                                                                                                                                                                |
| `FontBold`      | Boolean |          | `0`       | `1`: Make the font bold.                                                                                                                                                                                                                                                                          |
| `FontItalic`    | Boolean |          | `0`       | `1`: Make the font italic.                                                                                                                                                                                                                                                                        |
| `FontColor`     | Color   |          | `$000000` | Font color. `$BBGGRR` format.                                                                                                                                                                                                                                                                     |
| `FontUnderLine` | Boolean |          | `0`       | `1`: Underline the font.                                                                                                                                                                                                                                                                          |
| `TextAlign`     | Integer |          | `4`       | Text alignment. `0`: Top-left, `1`: Top, `2`: Top-right, `3`: Left, `4`: Center, `5`: Right, `6`: Bottom-left, `7`: Bottom, `8`: Bottom-right.                                                                                                                                                    |
| `ImageFileName` | String  |          |           | Filename of the image to display as the background (absolute or relative path).                                                                                                                                                                                                                   |

### 4.6. `[Line]`

Defines a line segment.

Placed on a single page.

| Key                 | Type    | Required | Default   | Description                                                                                                       |
|---------------------|---------|----------|-----------|-------------------------------------------------------------------------------------------------------------------|
| `Page`              | String  | Required |           | Page name.                                                                                                        |
| `Left`              | Integer | Required |           | Left position (in 0.1mm units).                                                                                   |
| `Top`               | Integer | Required |           | Top position (in 0.1mm units).                                                                                    |
| `Width`             | Integer | Required |           | Width (in 0.1mm units).                                                                                           |
| `Height`            | Integer | Required |           | Height (in 0.1mm units).                                                                                          |
| `ZOrder`            | Integer |          |           | The stacking order of the object. A smaller value means it's in the back, a larger value means it's in the front. |
| `LineColor`         | Color   |          | `$000000` | Line color. `$BBGGRR` format.                                                                                     |
| `LineWidth`         | Integer |          | `1`       | Line thickness.                                                                                                   |
| `LineType`          | Integer |          | `0`       | Line type. `0`: Solid, `2`: Dash, `3`: Dash-dot, `4`: Dash-dot-dot.                                               |
| `StartLineTermType` | Integer |          | `0`       | Shape of the start point. `0`: No mark, `1`: Circle, `2`: Filled circle, `3`: Arrow, `4`: Filled arrow, `5`: Diamond, `6`: Filled diamond. |
| `EndLineTermType`   | Integer |          | `0`       | Shape of the end point. `0`: No mark, `1`: Circle, `2`: Filled circle, `3`: Arrow, `4`: Filled arrow, `5`: Diamond, `6`: Filled diamond.   |
| `TermSize`          | Integer |          | `3`       | Size of the end points (1-5). A higher number means a larger size.                                                |

### 4.7. `[Comment]`

Defines a comment object, like a sticky note.

Placed on a single page.

| Key             | Type    | Required | Default   | Description                                 |
|-----------------|---------|----------|-----------|---------------------------------------------|
| `Comment`       | String  |          |           | Text to display.                            |
| `FontName`      | String  |          | `Tahoma`  | Font name.                                  |
| `FontSize`      | Float   |          | `9.0`     | Font size.                                  |
| `FontBold`      | Boolean |          | `0`       | `1`: Make the font bold.                    |
| `FontItalic`    | Boolean |          | `0`       | `1`: Make the font italic.                  |
| `FontColor`     | Color   |          | `$000000` | Font color. `$BBGGRR` format.               |
| `FontUnderLine` | Boolean |          | `0`       | `1`: Underline the font.                    |
| `LineColor`     | Color   |          |           | Frame color. `$BBGGRR` format.              |
| `BkColor`       | Color   |          |           | Background color. `$BBGGRR` format.         |
| `Page`          | String  | Required |           | Page name.                                  |
| `Left`          | Integer | Required |           | Left position (in 0.1mm units).             |
| `Top`           | Integer | Required |           | Top position (in 0.1mm units).              |
| `Width`         | Integer | Required |           | Width (in 0.1mm units).                     |
| `Height`        | Integer | Required |           | Height (in 0.1mm units).                    |
| `ZOrder`        | Integer |          |           | The stacking order of the object. A smaller value means it's in the back, a larger value means it's in the front. |

-----