# A5:SQL Mk-2 ER図ファイル形式仕様書 (Version 2.21系)

## 1. 概要

本仕様書は、データベースクライアントツール A5:SQL Mk-2 が使用する `.a5er` ER図ファイルの形式について記述します。

このファイルはテキストベースであり、INIファイルに似た構造をしています。文字エンコーディングは **UTF-8 (BOM付き)** です。

各設定項目は `項目=値` のペアで表現され、ER図を構成する各オブジェクト（エンティティ、リレーションなど）は `[セクション名]` で区切られます。

### 1.1. 基本構造

ファイルは以下の要素で構成されます。

1.  **ヘッダコメント**: ファイルの種類やバージョン情報を示します。`#` で始まる行はコメントとして扱われます。
2.  **`[Manager]` セクション**: ER図全体のグローバル設定を定義します。
3.  **オブジェクトセクション**: ER図を構成する各オブジェクト（エンティティ、リレーションシップなど）の定義が続きます。

以下サンプル

```ini
# A5:ER FORMAT:21
# A5:ER ENCODING:UTF8
# ... (その他のヘッダコメント)

[Manager]
PageInfo="Main",3,"A3Landscape",$FFFFFF

[Entity]
PName=users
LName=ユーザー
Field="ユーザーID","id","Serial","NOT NULL",0,"","",$FFFFFFFF,""
Field="ユーザー名","user_name","varchar(100)","NOT NULL",,"","",$FFFFFFFF,""
Field="誕生日","birthday","date","NOT NULL",,"","",$FFFFFFFF,""
IndexInfo="users_ix1",0,"user_name", ""
Position="Main",2350,800

[Entity]
PName=orders
LName=注文
Field="注文ID","id","Serial","NOT NULL",0,"","",$FFFFFFFF,""
Field="ユーザーID","user_id","Integer","NOT NULL",,"","",$FFFFFFFF,""
Position="Main",5000,800

[Relation]
Entity1=users
Entity2=orders
Fields1=id
Fields2=user_id
RelationType1=2
RelationType2=3
Position="MAIN",0,5000,5000,5000,R,R,""
```

※実際にA5:SQL Mk-2から出力される場合は、前方互換性のために追加の項目が出力されることがあります。

### 1.2. 値のフォーマット

  - **String**: 任意の文字列を表します。
  - **EscapedString**: 任意の文字列を表します。後述のルールでエスケープされます。
  - **Boolean**: `1` (True) または `0` (False) で表現されます。
  - **Color**: `$AABBGGRR` または `$BBGGRR` 形式の16進数で表現されます (例: `$000000`, `$FF000000`)。上位2桁がアルファチャネルではなく $FFFFFFFF がデフォルト色を表す場合もあります。
  - **Complex**: 複数の値をカンマ区切りで一つの行に記述します。文字列の値はダブルクォートで括られ、後述のルールでエスケープされます。

EscapedString および Complex 中の文字列は以下のルールでエスケープされます。

| 文字 | エスケープ表現 |
| ---- | -------------- |
| \\   | \\\\           |
| "    | \\Q            |
| '    | \\q            |
| タブ | \\t            |
| 改行 | \\n            |

-----

## 2. ヘッダコメント

ファイルの先頭には、コメントが記述されることがあります。

基本的にこれはコメントであるので、なくても問題ありませんが、A5:SQL Mk-2 では読み込み時に異なるバージョンで保存された形式であるかの判定や、ファイルエンコーディングの参考として使用されます。  
(ファイルエンコーディングは通常 ** UTF-8 (BOM付き) ** のみが使用されます。他のエンコーディングの使用は推奨されません。)

| 項目               | 説明                             | 例                      |
| ------------------ | ---------------------------------| ----------------------- |
| `# A5:ER FORMAT`   | ファイル形式番号。               | `# A5:ER FORMAT:21`     |
| `# A5:ER ENCODING` | ファイルの文字エンコーディング。 | `# A5:ER ENCODING:UTF8` |

A5:SQL Mk-2 のバージョンと対応するA5:ER FORMAT のバージョン番号は以下の通りです。

| A5:SQL Mk-2 バージョン | ファイル形式番号 |
| ---------------------- | ---------------- |
| Version 2.1            | 1                |
| Version 2.2            | 2                |
| Version 2.3            | 3                |
| Version 2.4            | 4                |
| Version 2.5            | 4                |
| Version 2.6            | 5                |
| Version 2.7            | 6                |
| Version 2.8            | 7                |
| Version 2.9            | 8                |
| Version 2.10           | 9                |
| Version 2.11           | 10               |
| Version 2.12           | 11               |
| Version 2.13           | 12               |
| Version 2.14           | 13               |
| Version 2.15           | 14               |
| Version 2.16           | 15               |
| Version 2.17           | 16               |
| Version 2.18           | 17               |
| Version 2.19           | 18               |
| Version 2.20           | 19               |
| Version 2.21           | 21               |

-----

## 3. `[Manager]` セクション

### 3.1. ER図全体のグローバルな設定

基本的な項目

| 項目                                 | 型            | 必須    | デフォルト   | 説明                                                                                                                                               |
| ------------------------------------ | ------------- | ------- | ------------ | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| `ProjectName`                        | EscapedString |         |              | プロジェクト名。                                                                                                                                   |
| `Author`                             | EscapedString |         |              | 著作者名。                                                                                                                                         |
| `MaxEntityRowShow`                   | Integer       |         | `1000`       | エンティティを表示する際の属性の最大行数。(超える場合は、その行数で表示が打ち切られ、「&lt;続きあり&gt;」などと表示する)                           |
| `ReadOnlyRecommend`                  | Boolean       |         | `0`          | `1`: 読み取り専用で開くことを推奨する。                                                                                                            |
| `Comment`                            | EscapedString |         |              | プロジェクトに関するコメント。                                                                                                                     |
| `PageInfo`                           | Complex       | 1個以上 |              | **【複合値】** ページに関する情報 **(ページごとに複数指定可能)** 。下記参照。                                                                      |
| `DomainInfo`                         | Complex       |         |              | **【複合値】** ドメイン（データ型のテンプレート）に関する情報 **(ドメインごとに複数指定可能)** 。下記参照。                                        |
| `LogicalView`                        | Boolean       |         | `0`          | `1`: 論理名表示, `0`: 物理名表示。                                                                                                                 |
| `DecodeDomain`                       | Boolean       |         | `0`          | 0: デコード無し, 1: ユーザー定義ドメインのみでコード, 2: ユーザー定義・システム定義ドメインをデコード                                              |
| `ViewFormat`                         | Integer       |         | `0`          | 表示形式  `0`: IE, `1`: IDEF1X                                                                                                                     |
| `UseNondependenceDashLine`           | Boolean       |         | `0`          | 非依存リレーションシップを点線で表示するか `0`: 実線, `1`: 点線                                                                                    |
| `FontName`                           | String        |         | `Tahoma`     | ER図で使用するデフォルトフォント名。                                                                                                               |
| `FontSize`                           | Float         |         | `9.0`        | デフォルトのフォントサイズ。                                                                                                                       |
| `HeaderLeft`                         | String        |         |              | 用紙のヘッダ左に出力する文字列。                                                                                                                   |
| `HeaderCenter`                       | String        |         |              | 用紙のヘッダ中央に出力する文字列。                                                                                                                 |
| `HeaderRight`                        | String        |         |              | 用紙のヘッダ右に出力する文字列。                                                                                                                   |
| `FooterLeft`                         | String        |         |              | 用紙のフッタ左に出力する文字列。                                                                                                                   |
| `FooterCenter`                       | String        |         |              | 用紙のフッタ中央に出力する文字列。                                                                                                                 |
| `FooterRight`                        | String        |         |              | 用紙のフッタ右に出力する文字列。                                                                                                                   |
| `ShowPageoutRelation`                | Boolean       |         | `1`          | 2つのページにまたがるリレーションシップの存在を描画するか。                                                                                        |
| `ShowTag`                            | Boolean       |         | `1`          | タグを表示するか。                                                                                                                                 |
| `ShowCommonAttributes`               | Boolean       |         | `0`          | 共通属性を表示するか。                                                                                                                             |
| `ShowDisableAttributes`              | Boolean       |         | `0`          | 無効に設定されている属性を表示するか。                                                                                                             |
| `BugFixEntityWidth`                  | Boolean       |         | `1`          | `1`: エンティティ幅の計算ロジックを修正。現行版では必ず1が出力されます。`0`の場合、エンティティの幅の自動計算が正しく動作しないことがあります。    |
| `CommonField`                        | Complex       |         |              | **【複合値】** 共通列に関する情報 **(共通列ごとに複数指定可能)** 。下記参照。                                                                      |

DDL生成関連の項目

| 指定                                 | 型      | 必須 | デフォルト        | 説明                                                                                                                                               |
| ------------------------------------ | ------- | ---- | ----------------- | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| `RDBMSTypeName`                      | String  |      | `Oracle Database` | 対象RDBMSの名称。(`Oracle Database`, `IBM Db2`, `Microsoft SQL Server 2000`, `Microsoft SQL Server 2005`, `Microsoft SQL Server 2008`, `Microsoft SQL Server 2016`, `MySQL`, `PostgreSQL`) |
| `GenerateComment`                    | Boolean |      | `1`               | `1`: `CREATE TABLE` 文やそのカラムにコメントを生成する。                                                                                           |
| `GenerateDropTableStatement`         | Boolean |      | `0`               | `1`: `DROP TABLE`文を生成する。                                                                                                                    |
| `DropTableIfExists`                  | Boolean |      | `0`               | `1`: `DROP TABLE`文を生成するときに、`IF EXISTS` オプションを付加する(PostgreSQL, SQL Server 2016, MySQL の場合のみ)                               |
| `BackupRestoreTempTable`             | Boolean |      | `1`               | `1`: `DROP TABLE`文に対して、`BackupToTempTable` 疑似命令を、`CREATE TABLE`文に対して、`RestoreFromTempTable` 疑似命令を付加する(DROP TABLE, CREATE TABLE 間でデータを一時テーブルにバックアップ・レストアするA5:SQL Mk-2の独自機能) |
| `ForceQuoteIdentifier`               | Boolean |      | `0`               | `1`: 識別子を常に引用符で囲む。                                                                                                                    |
| `EnableTableOption`                  | Boolean |      | `1`               | `1`: 指定されたテーブルオプションをDDLに付加する。                                                                                                 |
| `CreatePkIndex`                      | Boolean |      | `0`               | `1`: 主キー項目に対して、インデックスを生成してから `ALTER TABLE` で主キーを割り当てる。                                                           |
| `CreateFk`                           | Boolean |      | `0`               | `1`: 外部キー制約を生成する。                                                                                                                      |
| `FkOnDeleteOption`                   | String  |      |                   | 外部キーの削除時のオプション(`CASCADE` など。先頭に `ON DELETE` はついていても付いていなくてもよい)                                                |
| `FkOnUpdateOption`                   | String  |      |                   | 外部キーの更新時のオプション(`NOACTION`, `CASCADE`, `SET NULL`, `SET DEFAULT`  など。先頭に `ON DELETE` は付いていても付いていなくてもよい)        |
| `CreateFK_ParentCard1Only`           | Boolean |      | `0`               | `1`: リレーションシップの親側のカーディナリティが 1 の場合のみ外部キーを生成する。                                                                 |
| `FKParentIndex`                      | Boolean |      | `0`               | `1`: 外部キーの親側に(すでに付加されていなければ)インデックスを生成する(リレーションシップの親側が主キー出ない場合など用)                          |
| `GenerateCommentStatement`           | Boolean |      | `1`               | `1`: テーブル/カラム用のコメントステートメントを生成する。                                                                                         |
| `GenerateCommentStatement_LName`     | Boolean |      | `1`               | `1`: コメントステートメントにオブジェクトの論理名を含める。                                                                                        |
| `GenerateCommentStatement_Comment`   | Boolean |      | `1`               | `1`: コメントステートメントにオブジェクトのコメントを含める。                                                                                      |
| `GenerateCommentStatement_Separator` | String  |      | `:`               | コメントステートメントに論理名とコメントを含めるときのセパレータ文字列                                                                             |
| `DefaultPkName`                      | String  |      | `%0:s_PKC`        | 主キー制約名のデフォルトフォーマット。(`%s`, `%0:s` をエンティティ物理名に置換します)                                                              |
| `DefaultPkIndexName`                 | String  |      | `%0:s_PKI`        | 主キーインデックス名のデフォルトフォーマット。(`%s`, `%0:s` をエンティティ物理名に置換します)                                                      |
| `DefaultIndexName`                   | String  |      | `%0:s_IX%1:d`     | 主キー以外のインデックス名のデフォルトフォーマット。(`%s`, `%0:s` をエンティティ物理名に置換します。`%d`, `%1:d` をインデックス番号に置換します。) |
| `DefaultFkName`                      | String  |      | `%0:s_FK%1:d`     | 外部キー制約名のデフォルトフォーマット。(`%s`, `%0:s` をエンティティ物理名に置換します。`%d`, `%1:d` をインデックス番号に置換します。)             |
| `SqlSeparator`                       | Integer |      | `0`               | SQLステートメントのセパレータ。 `0`: セミコロン, `1`: '/' のみの行, `2`: 'GO' のみの行                                                             |
| `UpperCaseKeyword`                   | Boolean |      | `0`               | `1`: キーワードを大文字にする。                                                                                                                    |
| `CreateOrder`                        | String  |      | `Default`         | `CREATE TABLE`の順序。`Default`, `PName`, `LName`, `Tag`, `Dependent`。`Default`の場合、ER図上の配置順によって生成され、先に配置したもの(奥に配置されているもの)から生成する。 |

※ この他に `Page`, `Domain`, `ViewModePageIndividually`, `ViewMode`, `PaperSize`, `RDBMSType` 項目が出力されますが、互換性のための古い項目であり、無視してかまいません。

### 3.1.1. ヘッダとフッタ文字列

`HeaderLeft`, `HeaderCenter`, `HeaderRight`, `FooterLeft`, `FooterCenter`, `FooterRight` では次の文字列の置換が行われます。

| 元文字列      | 置換後文字列               |
| ------------- | -------------------------- |
| %FileName%    | ファイル名(パスを含まない) |
| %PageCount%   | 全ページ数                 |
| %PageNo%      | ページ番号                 |
| %PageName%    | ページ名                   |
| %Date%        | 日付                       |
| %Time%        | 時刻                       |
| %ProjectName% | プロジェクト名             |
| %Author%      | 著作者名                   |
| %%            | `%`                        |

  - **例**: `FooterCenter=%PageNo%/%PageCount%`

### 3.1.2. ページ設定(複合値)

ページ情報は `PageInfo` のキーで保存されます。  
ページ情報はER図で最低1個必要となります。各オブジェクトのプロパティ中で指定されるページ名はこのページ情報で指定するページ名と一致する必要があります。  
１ページに表示しきれないエンティティをページごとに分けたり、サブモデルとしてページを分けたりできます。  

  - **`PageInfo`**: ページの詳細情報を定義します。
    - **フォーマット**: `"ページ名",表示モード,"用紙サイズ","背景色"`
      - `ページ名`: ページ名。複数のページがある場合、大文字小文字の区別なしでユニークになる必要があります。
      - `表示モード`: `0`: エンティティ, `1`: 主キー, `2`: 属性, `3`: 属性とデータ型, `4`: 属性とデータ型・位置揃え, `5`: 属性の論理/物理名, `6`: 属性の論理/物理名とデータ型, `7`: 属性の論理/物理名とデータ型・位置揃え
      - `用紙サイズ`: `A4Landscape`, `A4Portrait`, `A3Landscape` など。用紙サイズ(`A4` ～ `A1`, `B4` ～ `B2`) と `Landscape`, `Portrait` の組み合わせ文字列。
      - `背景色`: `$BBGGRR` 形式

  - **例**: `PageInfo="Main",3,"A3Landscape",$FFFFFF`

※文字列項目はダブルクォートで括られます。
※用紙サイズで指定される描画エリアのうち、上下左右の5mmは余白として処理されます。この余白をのぞいたエリアでエンティティなどのオブジェクトの位置が 0.1mm 単位で指定されます。

### 3.1.2. ドメイン設定

ユーザー定義ドメイン（データ型のテンプレート）を `DomainInfo` のキーで保存できます。

  - **フォーマット**: `"ドメイン名","データ型","コメント","カラム物理名"`
    - `ドメイン名`: ドメインの名前: 複数のドメインがある場合、大文字小文字の区別なしでユニークになる必要があります。
    - `データ型`: データ型、またはユーザードメイン・システムドメイン名。
    - `コメント`: ドメインのコメント。
    - `カラム物理名`: カラム物理名は、エンティティでドメインを指定したときのデフォルトとして使用されますが、名前が強制されるわけではありません。

  - **例**: `DomainInfo="ID","INTEGER","ユニークID","id"`

`データ型` はシステムで事前に定義されている `@` から始まる `システム定義ドメイン` が指定されることもあります。

| システム定義ドメイン | 意味               |
| -------------------- | ------------------ |
| @VARCHAR             | 可変長文字列       |
| @CHAR                | 固定長文字列       |
| @DECIMAL             | 数字型             |
| @INT                 | 整数型             |
| @FLOAT               | 単精度浮動小数点型 |
| @DOUBLE              | 倍精度浮動小数点型 |
| @DATE                | 日付型             |
| @TIME                | 時刻型             |
| @DATETIME            | 日付時刻型         |
| @BOOLEAN             | 論理値型           |

これらのシステム定義ドメインは選択したリレーショナルデータベース型に応じて適切な型でDDLが生成されます。

### 3.1.3. 共通列設定

共通列設定は `CommonField` のキーで保存されます。

  - **フォーマット**: `"共通列論理名","共通列物理名","データ型","NOT NULL","キー順","デフォルト値","コメント",色`
    - `共通列論理名`: 共通列の論理名。
    - `共通列物理名`: 共通列の物理名。複数の共通列がある場合、大文字小文字の区別なしでユニークになる必要があります。
    - `データ型`: データ型、またはユーザードメイン・システムドメイン名。
    - `NOT NULL`: `NotNull` の場合はこの文字列、`Null`許容の場合は空。
    - `キー順`: 主キーの場合`0`から始まるインデックス。主キーでない場合は空。
    - `デフォルト値`: デフォルト値を表す式。主キーでない場合は空。
    - `コメント`: コメント
    - `色`: `$AARRGGBB` 形式。ただし、AAはアルファチャネルではなく、`$FFFFFFFF` のとき、デフォルト色を表す。

  - **例**: `CommonField="削除日時","deleted_at","timestamp",,,,"このカラムがNULLでない場合、論理削除されたとみなす。",$FFFFFFFF`
  
データ型はシステムで事前に定義されている `@` から始まる `システム定義ドメイン` が指定されることもあります。

| システム定義ドメイン | 意味                 |
| -------------------- | -------------------- |
| @VARCHAR             | 可変長文字列         |
| @CHAR                | 固定長文字列         |
| @DECIMAL             | 数字型               |
| @INT                 | 整数型(32bit)        |
| @FLOAT               | 単精度浮動小数点数型 |
| @DOUBLE              | 倍精度浮動小数点数型 |
| @DATE                | 日付型               |
| @TIME                | 時刻型               |
| @DATETIME            | 日付時刻型           |
| @BOOLEAN             | 論理値型             |

これらのシステム定義ドメインは選択したリレーショナルデータベース型に応じて適切な型でDDLが生成されます。

-----

## 4. オブジェクトセクション

### 4.1. `[Entity]`

エンティティ（テーブル）を定義します。

単一のオブジェクトを複数のページに配置できます。

| 項目                 | 型            | 必須    | デフォルト | 説明                                                                                                                                     |
| -------------------- | ------------- | ------- | ---------- | ---------------------------------------------------------------------------------------------------------------------------------------- |
| `PName`              | String        | 必須    |            | 物理名 (テーブル名)。ER図内の全オブジェクトでユニークである必要がある。                                                                  |
| `LName`              | String        |         |            | 論理名。                                                                                                                                 |
| `Comment`            | EscapedString |         |            | エンティティのコメント。                                                                                                                 |
| `TableInnerOption`   | EscapedString |         |            | `CREATE TABLE`文のかっこの中に付加されるオプション。                                                                                     |
| `TableOption`        | EscapedString |         |            | `CREATE TABLE`文の末尾に付加されるオプション。                                                                                           |
| `Field`              | Complex       |         |            | **【複合値】** 属性（カラム）定義 **(列ごとに複数指定可能)** 。下記参照。                                                                |
| `IndexInfo`          | Complex       |         |            | **【複合値】** インデックス定義 **(インデックスごとに複数指定可能)** 。下記参照。                                                        |
| `NoDDL`              | Boolean       |         | `0`        | `1`: DDL生成の対象外とする。                                                                                                             |
| `UsingCommonColumns` | Boolean       |         | `1`        | `1`: 共通属性を使用する。                                                                                                                |
| `EffectMode`         | String        |         | `None`     | 背景効果。`None`, `Gradation`。                                                                                                          |
| `Tag`                | String        |         |            | エンティティに付与するタグ。(タグはエンティティの種類を指定するためにユーザーが自由に指定します。A5:SQLの中では特に意味を持ちません。)   |
| `Color`              | Color         |         | `$000000`  | 前景色。 `$BBGGRR` 形式。                                                                                                                |
| `BkColor`            | Color         |         | `$FFFFFF`  | 背景色。 `$BBGGRR` 形式。                                                                                                                |
| `ModifiedDateTime`   | String        |         |            | 最終編集日時を表す `YYYYMMDDhhmmss` 形式の文字列。                                                                                       |
| `Position`           | Complex       | 1個以上 |            | **【複合値】** ページごとの線の描画情報 **(複数キー項目)** 。下記参照。                                                                  |
| `ZOrder`             | Integer       |         |            | オブジェクトの重なり順序。値が大きいほど手前。                                                                                           |

※ この他に `Page`, `Left`, `Top`, `Index`, `IndexOption` 項目が出力されますが、互換性のための古い項目であり、無視してかまいません。


#### 4.1.1. `Field` (複合値)

  - **フォーマット**: `"論理名","物理名","データ型","NOT NULL",キー順,"デフォルト値","コメント",色,"オプション","追加オプション"`
    - `論理名`: 列の論理名。
    - `物理名`: 列の物理名。
    - `データ型`: 列のデータ型、またはユーザードメイン・システムドメイン名。
    - `NOT NULL`: NOT NULL の場合は "NOT NULL"、NULL 許容の場合は空。
    - `キー順`: 主キーの場合`0`から始まるインデックス(Integer)。主キーでない場合は空。
    - `デフォルト値`: デフォルト値を表す式。主キーでない場合は空。
    - `コメント`: コメント。
    - `色`(必須): **`$AARRGGBB`** 形式。ただし、AAはアルファチャネルではなく、`$FFFFFFFF` のとき、デフォルト色を表す。
    - `オプション`: DDL生成時にカラム定義の末尾に付加される文字列。
    - `追加オプション`: 無効列の場合、"DISABLE" が入る。(将来のバージョンではカンマ区切りで別の文字列も入る可能性がある)

  - **例**: `Field="ユーザーID","id","INTEGER","NOT NULL",0,"","ユーザーのユニークID",$FFFFFFFF,"",""`

※文字列項目はダブルクォートで括られます。

#### 4.1.2. `IndexInfo` (複合値)

  - **フォーマット**: `"インデックス名",ユニークフラグ,"カラムリスト","インデックスオプション"`
    - `インデックス名`: インデックスの名前
    - `ユニークフラグ`: `0`: 非ユニーク, `1`: ユニーク, `2`: ユニーク制約
    - `カラムリスト`: カンマ区切りのカラム名リスト
    - `インデックスオプション`: インデックスのオプション。CREATE INDEX の最後に付加される。

  - **例**: `IndexInfo="users_ix1",0,"user_name,birthday", ""`

※一部項目はダブルクォートで括られていることに注意してください。

#### 4.1.3. `Position` (複合値)

  - **フォーマット**: `"ページ名",X座標,Y座標,幅,高さ`
    - `ページ名`: `[Manager]` セクションで定義されるページのページ名を指定する。
    - `X座標`: 0.1mm 単位でのX座標 (用紙サイズ - 1.0cm 以内であること。用紙サイズが A3Landscape である場合、4100 未満。オブジェクトの幅も考慮すると 4000 程度未満を推奨。)
    - `Y座標`: 0.1mm 単位でのY座標 (用紙サイズ - 1.0cm 以内であること。用紙サイズが A3Landscape である場合、2870 未満。オブジェクトの幅も考慮すると 2500 程度未満を推奨。)
    - `幅`と`高さ`はサイズを固定する場合のみ出力される。自動計算するときは出力されない。
    - 数字の単位は 0.1mm となります。

  - **例(幅・高さなし)**: `Position="Main",100,500`
  - **例(幅・高さあり)**: `Position="Main",100,500,400,900`

※文字列項目はダブルクォートで括られます。

### 4.2. `[Relation]` / `[Relationship]`

エンティティ間のリレーションシップを定義します。

| 項目                 | 型      | 必須 | デフォルト | 説明                                                                                                    |
| -------------------- | ------- | ---- | ---------- | ------------------------------------------------------------------------------------------------------- |
| `Entity1`, `Entity2` | String  | 必須 |            | 親(1)と子(2)のエンティティ物理名。                                                                      |
| `Fields1`, `Fields2` | String  | 必須 |            | 親(1)と子(2)の関連カラム物理名（カンマ区切り）。                                                        |
| `RelationType1`      | Integer | 必須 | `1`        | カーディナリティ。`0`: 指定なし, `1`: 0または1, `2`: 1, `3`: 0以上, `4`: 1以上, `5`: N個固定            |
| `RelationType2`      | Integer | 必須 | `3`        | カーディナリティ。`0`: 指定なし, `1`: 0または1, `2`: 1, `3`: 0以上, `4`: 1以上, `5`: N個固定            |
| `Cardinarity1`       | String  |      |            | IDEF1X表示時のカーディナリティ文字列（例: "P", "Z"）。                                                  |
| `Cardinarity2`       | String  |      |            | IDEF1X表示時のカーディナリティ文字列（例: "P", "Z"）。                                                  |
| `Dependence`         | Boolean |      | `0`        | `1`: 依存リレーションシップ。                                                                           |
| `Caption`            | String  |      |            | 動詞句。リレーションシップの中央に表示されるテキスト。                                                  |
| `PName`              | String  |      |            | 外部キー制約の物理名。                                                                                  |
| `NoDDL`              | Boolean |      | `0`        | `1`: DDL生成の対象外とする。                                                                            |
| `LineColor`          | Color   |      | `$000000`  | 線の色。`$BBGGRR` 形式。                                                                                |
| `FkOnDeleteOption`   | String  |      |            | 外部キーデータ削除時のオプション                                                                        |
| `FkOnUpdateOption`   | String  |      |            | 外部キーデータ更新時のオプション                                                                        |
| `Position`           | Complex |      |            | ページごとの線の描画情報 **(複数キー項目)** 。下記参照。                                                |
| `ZOrder`             | Integer |      |            | オブジェクトの重なり順序。値が大きいほど手前。                                                          |
| `ModifiedDateTime`   | String  |      |            | 最終編集日時を表す `YYYYMMDDhhmmss` 形式の文字列。                                                      |

※ この他に `LineMode`, `Bar1`, `Bar2`, `Bar3`, `TermPos1`, `TermPos2` 項目が出力されますが、互換性のための古い項目であり、無視してかまいません。

#### 4.2.1. `Position` (複合値)

  - **フォーマット**: `"ページ名",ラインモード,線位置1,線位置2,線位置3,端子位置1,端子位置2,"頂点座標リスト"`
    - `ラインモード`(必須): 線の描画モード (`0`: 自動, `1`: 縦-横-縦, `2`: 横-縦-横, `3`: 縦-横, `4`: 横-縦, `5`: (⊐) 型, `6`: (⊏) 型, `7`: 直線(自動), `8`: 直線(縦 端子), `9`: 直線(横 端子), `10`: 自由結線)。
    - `線位置1-3`(必須): 線の折れ曲がる位置を決めるパラメータ（0～10000）。折れ曲がる位置が左・上であるほど 0 に近くなり、右・下であるほど 10000 に近くなる。
    - `端子位置1-2`(必須): 別ページへのリレーションの場合の端子の向き（`R`, `L`）。
    - `頂点座標リスト`: 自由結線モード時の頂点座標リスト（`;`区切り）。

  - **例**: `Position="Main",0,5000,5000,5000,R,R,""`

※文字列項目はダブルクォートで括られます。

### 4.3. `[View]`

ビューを定義します。`[Entity]` セクションと多くの項目を共有しますが、`Field`や`Index`は持ちません。

単一のオブジェクトを複数のページに配置できます。

| 項目                 | 型      | 必須    | デフォルト | 説明                                                                  |
| -------------------- | ------- | ------- | ---------- | --------------------------------------------------------------------- |
| `PName`              | String  | 必須    |            | 物理名 (ビュー名)。ER図内の全オブジェクトでユニークである必要がある。 |
| `LName`              | String  |         |            | 論理名。                                                              |
| `Comment`            | String  |         |            | エンティティのコメント。                                              |
| `Query`              | String  |         |            | ビューを定義するSELECT文。                                            |
| `LNameByComment`     | Boolean |         | `0`        | `1`: SELECT文内のコメントをカラムの論理名とする。                     |
| `MaterializedView`   | Boolean |         | `0`        | `1`: マテリアライズドビューとして扱う。                               |
| `NoDDL`              | Boolean |         | `0`        | `1`: DDL を生成しない。                                               |
| `Color`              | Color   |         |            | 前景色。 `$BBGGRR` 形式。                                             |
| `BkColor`            | Color   |         |            | 背景色。 `$BBGGRR` 形式。                                             |
| `ModifiedDateTime`   | String  |         |            | 最終編集日時を表す `YYYYMMDDhhmmss` 形式の文字列。                    |
| `Position`           | String  | 1個以上 |            | `[Entity]` セクションと共通のプロパティ。                             |
| `ZOrder`             | Integer |         |            | オブジェクトの重なり順序。値が大きいほど手前。                        |
| `EffectMode`         | String  |         | `None`     | 背景効果。`None`, `Gradation`。                                       |

※ この他に `Page`, `Left`, `Top` 項目が出力されますが、互換性のための古い項目であり、無視してかまいません。

### 4.4. `[Subtype]`

サブタイプを定義します。

単一のオブジェクトを複数のページに配置できます。

| キー                 | 型      | 必須    | デフォルト | 説明                                                                              |
| -------------------- | ------- | ------- | ---------- | --------------------------------------------------------------------------------- |
| `PName`              | String  | 必須    |            | 物理名 (自動的に決定されます)。ER図内の全オブジェクトでユニークである必要がある。 |
| `SharedMode`         | Boolean |         | `0`        | `1`: 共有モード。IE表記でのサブタイプシンボルが `X` になる, `0`: 排他モード       |
| `CompleteCategory`   | Boolean |         | `0`        | `1`: IDEF1X表記での確定 IDEF1X表記で確定カテゴリ（二重丸）になる, `0`: 未確定     |
| `Position`, `ZOrder` | -       | 1個以上 |            | `[Entity]`セクションと共通のプロパティ。                                          |

### 4.5. `[Shape]`

四角形、円、矢印などの図形を定義します。

単一のページに配置されます。

| キー            | 型      | 必須 | デフォルト | 説明                                                                                                           |
| --------------- | ------- | ---- | ---------- | -------------------------------------------------------------------------------------------------------------- |
| `Page`          | String  | 必須 |            | ページ名。                                                                                                     |
| `Left`          | Integer | 必須 |            | 左位置 (0.1mm単位)                                                                                             |
| `Top`           | Integer | 必須 |            | 上位置 (0.1mm単位)                                                                                             |
| `Width`         | Integer | 必須 |            | 幅 (0.1mm単位)                                                                                                 |
| `Height`        | Integer | 必須 |            | 高さ (0.1mm単位)                                                                                               |
| `ZOrder`        | Integer |      |            | 数字が小さいほうが奥、大きいほうが手前                                                                         |
| `ShapeType`     | String  | 必須 |            | 図形の種類。`Rectangle`: 四角形, `RoundRect`: 角丸四角, `Ellipse`: 楕円, `Round`: 円, `Cross`: バツ印, `StickMan`: 棒人間, `AllowUpper`: 上向き矢印, `AllowLower`: 下向き矢印, `AllowLeft`: 左向き矢印, `AllowRight`: 右向き矢印, `Database`: データベース(ドラムのような), `Mail`:メール(封筒のような), `Window`: ウィンドウ(GUI ウィンドウ)。 |
| `LineColor`     | Color   |      | `$000000`  | 線の色。 `$BBGGRR` 形式。                                                                                      |
| `LineWidth`     | Integer |      |            | 線の太さ。`$BBGGRR` 形式。                                                                                     |
| `LineType`      | Integer |      |            | 線の種類。 `0`: 実線, `1`: 線無し, `2`: ダッシュ, `3`: ダッシュドット, `4`: ダッシュドットドット               |
| `BrushColor`    | Color   |      | `$FFFFFF`  | 塗りつぶしの色。`$BBGGRR` 形式。                                                                               |
| `BrushAlpha`    | Integer |      | `255`      | 塗りつぶしの不透明度 (0-255)。                                                                                 |
| `RoundRectR`    | Integer |      |            | RoundRect の際のコーナーの半径(0.1mm単位)                                                                      |
| `Text`          | String  |      |            | 図形内に表示するテキスト。                                                                                     |
| `FontName`      | String  |      | `Tahoma`   | フォント名。                                                                                                   |
| `FontSize`      | Float   |      | `9.0`      | デフォルトのフォントサイズ。                                                                                   |
| `FontBold`      | Boolean |      | `0`        | `1`: フォントを太字にする。                                                                                    |
| `FontItalic`    | Boolean |      | `0`        | `1`: フォントを斜体にする。                                                                                    |
| `FontColor`     | Color   |      | `$000000`  | フォントの色。`$BBGGRR` 形式。                                                                                 |
| `FontUnderLine` | Boolean |      | `0`        | `1`: フォントに下線を引く。                                                                                    |
| `TextAlign`     | Integer |      | `4`        | テキストの配置  `0`: 左上, `1`: 上, `2`: 右上, `3`: 左, `4`: 中央, `5`: 右, `6`: 左下, `7`: 下, `8`: 右下      |
| `ImageFileName` | String  |      |            | 画像を表示する場合、背景として表示する画像ファイル名(絶対パスまたは相対パス)。                                 |

### 4.6. `[Line]`

線分を定義します。

単一のページに配置されます。

| キー                | 型      | 必須 | デフォルト | 説明                                                                                                                         |
| ------------------- | ------- | ---- | ---------- | ---------------------------------------------------------------------------------------------------------------------------- |
| `Page`              | String  | 必須 |            | ページ名。                                                                                                                   |
| `Left`              | Integer | 必須 |            | 左位置 (0.1mm単位)                                                                                                           |
| `Top`               | Integer | 必須 |            | 上位置 (0.1mm単位)                                                                                                           |
| `Width`             | Integer | 必須 |            | 幅 (0.1mm単位)                                                                                                               |
| `Height`            | Integer | 必須 |            | 高さ (0.1mm単位)                                                                                                             |
| `ZOrder`            | Integer |      |            | 数字が小さいほうが奥、大きいほうが手前。                                                                                     |
| `LineColor`         | Color   |      | `$000000`  | 線の色。 `$BBGGRR` 形式。                                                                                                    |
| `LineWidth`         | Integer |      | `1`        | 線の太さ。                                                                                                                   |
| `LineType`          | Integer |      | `0`        | 線の種類。 `0`: 実線, `2`: ダッシュ, `3`: ダッシュドット, `4`: ダッシュドットドット                                          |
| `StartLineTermType` | Integer |      | `0`        | 始点の形状。 `0`: マーク無し, `1`: 丸, `2`: 塗りつぶし丸, `3`: 矢印, `4`: 塗りつぶし矢印, `5`: ひし形, `6`: 塗りつぶしひし形 |
| `EndLineTermType`   | Integer |      | `0`        | 終点の形状。 `0`: マーク無し, `1`: 丸, `2`: 塗りつぶし丸, `3`: 矢印, `4`: 塗りつぶし矢印, `5`: ひし形, `6`: 塗りつぶしひし形 |
| `TermSize`          | Integer |      | `3`        | 端点のサイズ (1-5)。数値が大きいほうが大きい。                                                                               |

### 4.7. `[Comment]`

付箋のようなコメントオブジェクトを定義します。

単一のページに配置されます。

| キー            | 型      | 必須 | デフォルト | 説明                                     |
| --------------- | ------- | ---- | ---------- | ---------------------------------------- |
| `Comment`       | String  |      |            | 表示するテキスト。                       |
| `FontName`      | String  |      | `Tahoma`   | フォント名。                             |
| `FontSize`      | Float   |      | `9.0`      | フォントサイズ。                         |
| `FontBold`      | Boolean |      | `0`        | `1`: フォントを太字にする。              |
| `FontItalic`    | Boolean |      | `0`        | `1`: フォントを斜体にする。              |
| `FontColor`     | Color   |      | `$000000`  | フォントの色。`$BBGGRR` 形式。           |
| `FontUnderLine` | Boolean |      | `0`        | `1`: フォントに下線を引く。              |
| `LineColor`     | Color   |      |            | 枠線の色。`$BBGGRR` 形式。               | 
| `BkColor`       | Color   |      |            | 背景色。`$BBGGRR` 形式。                 |
| `Page`          | String  | 必須 |            | ページ名。                               |
| `Left`          | Integer | 必須 |            | 左位置 (0.1mm単位)                       |
| `Top`           | Integer | 必須 |            | 上位置 (0.1mm単位)                       |
| `Width`         | Integer | 必須 |            | 幅 (0.1mm単位)                           |
| `Height`        | Integer | 必須 |            | 高さ (0.1mm単位)                         |
| `ZOrder`        | Integer |      |            | 数字が小さいほうが奥、大きいほうが手前。 |

-----
