﻿# 更新履歴

### Version 2.21.0 2026/01/25
機能追加・変更
- AIに質問する機能をAIチャット機能へ置き換え
- AI機能利用時のDBメタデータ取得の高速化
- AI機能でER図を更新する機能を追加
- AI機能で利用可能なサービスの拡充(Microsoft Foundry, Microsoft Foundry Local, Google Vertex AI API)
- AI機能で複数のAIサービス・モデル・設定を登録し、切り替えて使えるように変更(AIアシスタント)
- SQLエディタで共通表式のサブクエリをSQL全体を書き換えずにテスト実行する機能を追加
- SQLエディタの Replace 疑似命令において、置換後文字列で $1, $2や ${10} などのプレースホルダを使った部分置換に対応(Replace 疑似命令の破壊的仕様変更)
- ER図ファイルフォーマット仕様書を添付(a5er_specification.jpn.md, a5er_specification.enu.md)
- ERエディタの関数インデックス対応
- ER図で無効化列を表示できるように修正
- ER図のExcelファイル形式でのエンティティ定義書出力の高速化・Microsoft Excel がインストールされていなくても出力できるように変更(事前にファイル名を指定する必要あり)
- DBのExcelファイル形式でのテーブル定義書出力の高速化・Microsoft Excel がインストールされていなくても出力できるように変更(事前にファイル名を指定する必要あり)
- Cybozu kintone のアプリ情報をER図にリバース生成する機能の追加



### Version 2.20.4 2025/07/23
機能追加・変更
- SQLスクリプト実行機能で、「エラーで停止する」オプションを追加

不具合修正
- DB接続の登録で ssh.exe 使用時に意図せず設定画面のキーファイル入力欄が非表示になる問題を修正
- QL整形で LEFT関数/RIGHT関数があった時に LEFT JOIN/RIGHT JOIN と混同して改行してしまう問題の修正
- 外部キーのカラム名が間違って（親テーブル側のカラム名で）取得される不具合を修正
- SQLスクリプト実行機能で、SELECT文を実行するとハングアップする不具合を修正


### Version 2.20.3 2025/04/06
機能追加・変更
- PostgreSQL でトランザクション中にSQL実行エラーがあった時もロールバックしなくても処理を続行できるように修正
- 結果セットのフェッチサイズを指定できるように修正
- ER図をPDFで印刷する機能で、Microsoft Print to PDFが無いとき、メニュー項目をグレーアウトではなく、メニュー実行時にエラーメッセージを出すように変更
- 結果セットグリッドで数値型表示時に3桁ごとに区切り記号を表示するように変更
- SQLエディタでフォントのリガチャを使用するオプション値のデフォルトをOFFに変更(すでにONになっているインストール済み環境は変化しません)

不具合修正
- SQLエディタのAIペインでAIからのレスポンスを受け取っている途中経過表示で改行コードが正しく表示されない問題を修正
- SQLエディタで構文入力支援からDB接続すると文字入力ができなくなる不具合修正
- テキストエディタ部で、日本語入力したときにフォント設定によってはキャレット位置がずれていく不具合を修正


### Version 2.20.2 2025/02/16
機能追加・変更
- AIでSQLにコメントをつける機能で、差分比較画面を追加
- 各AIサービスのモデル列挙でモデル名でソートするように修正
- DBツリーからSQLエディタへドラッグ時にキャレットが表示されるように修正(### Version 2.19系までの挙動に近い仕様に修正)

不具合修正
- 外部キーが正しく列挙できない不具合を修正(### Version 2.17.0以降の不具合)
- x86 版で、ER図のエンティティのプロパティでハングアップする不具合修正(### Version 2.20.0以降の不具合)
- Oracle Database の PL/SQL エラーの時にエラー内容が表示されない不具合修正(発生バージョンは未確認)
- PostgreSQL でスキーマ名に大文字や記号・全角文字等が混じっていると外部キーの列挙に失敗する不具合を修正(### Version 2.17.0以降の不具合)
- コンソール画面のコピー機能がテキスト全体になってしまう不具合を修正(これまでの全バージョン)
- SQLエラー時にAIを呼び出すと、システムプロンプト生成の間、キャンセルボタンが押せない不具合の修正(### Version 2.20.0以降の不具合)
- mariadb で、テーブルを一括エクスポートするとき、INSERT形式で "Commands out of sync; You can’t run this command now" エラーが出る不具合修正(発生バージョンは未確認)
- AIが改行をLFで返してきたときにテキストエディタコンポーネントが改行を正しく扱えない問題を修正(### Version 2.20.0以降の不具合)


### Version 2.20.1 2025/01/19
機能追加・変更
- AIでSQLを編集する機能を追加
- AIサービスのモデル一覧の最新化
- Windows Vista 以降でのテキストエディタのデフォルトフォントを Consolas に変更
- 64bit 版でのテキストエディタのフォントレンダリングでアンチエイリアスを調整

不具合修正
- SQLエディタでMySQLに接続したときに、MySQLの関数が黒字の太字で表示され、キャレット位置がずれる不具合を修正(### Version 2.20.0の不具合)
- Oracle Database, IBM Db2, Microsoft SQL Server でテーブル定義の変更を2回操作するとエラーになる不具合修正(### Version 2.20.0の不具合)
- Oracle Database, IBM Db2, Microsoft SQL Server 操作後に A5:SQL Mk-2が終了できなくなる不具合修正(### Version 2.20.0の不具合)
- スキーマ間のデータ転送機能で一部データ型でエラーが起こる不具合を修正(### Version 2.20.0の不具合)
- データベースツリーの幅を0にしてしまうと元に戻せなくなる不具合を修正(### Version 2.20.0の不具合)


### Version 2.20.0 2025/01/01
機能追加・変更
- AIアシスタント機能を実装
  - SQLエディタにAIアシスタントペインを追加(様々な質問が可能)
  - コメントからSQLを生成する機能
  - SQLを解説してもらう機能
  - SQLにコメントを付加してもらう機能
  - DBやER図のテーブル・カラムの論理名をつけてもらう機能
  - SQLの実行計画で改善してもらう機能
  - SQLのエラーの原因と修正案を提示してもらう機能
  - 以下の外部AIサービスに対応(Ollama 以外は AIサービスへの契約とAPIキーが必要)
    - Anthropic - Claude v1
    - Google - Gemini v1
    - Microsoft - Azure OpenAI
    - OpenAI - ChatGPT v1
    - Ollama
- テキストエディタコンポーネントの置き換え(プロプライエタリからオープンソースのものに変更)
- SSH経由の接続で、Windows OSに付属する ssh.exe を利用できるように変更(.ssh_config に記述することで多段SSHなどにも対応)
- タブの表示名や色を変更できるように変更
- データベースの登録画面で、ODBCデータソースを個別に登録できるように改善
- Blob エディタで、データがJSONまたはXMLの場合、カラー構文表示できるように修正
- ERエディタで、サブタイプの大きさを変更できるように変更


### Version 2.19.2 2024/06/23
不具合修正
- with 句のあるSQL文でSQL入力支援機能を使用すると不具合が発生する不具合を修正
- SQLエディタで複数の結果セットを扱う時、結果セットタブ切り替え時にフィルター式が効かなくなる不具合修正
- 読み取り専用モードの時、SQL実行時にセミコロンで区切られた複数のSQLを単一のSQLとして実行できないようにした。
- 読み取り専用モードの時、insert, update, delete, create, alter のキーワードを含むクエリーを実行できないようにした。
- 「MySQLでSQLを2回実行し、結果セットを比較」を実行すると、「Commands out of sync; You can't run this command now」が発生する不具合の修正
- Excelコピー時に日付時刻データにミリ秒のデータがあると書式がおかしくなる不具合修正
- PostgreSQL で Date, Timestamp 型の Infinity, -Infinity の表示でエラーになる不具合を修正


### Version 2.19.1 2024/02/25
機能追加・変更
- フィルター計算式・論理削除業をグレー表示する評価式で、キーワードを識別子として私用してもエラーにならないように修正
- 最近使ったタブを使用するかや、タブの個数をオプションで設定できるようにした
- SQLエディタで結果セットをエクスポートするとき、DataTitle 疑似命令の指定をデフォルトファイル名として採用するように修正
- データ転送の直前に確認メッセージボックスを表示するように修正
- ERリバース生成時にリレーションシップの親側端子を 0or1 または 1で判定できるようにした。

不具合修正
- MySQL で結果セット最大行数以上の結果セットを読み込むと動作がおかしくなる（表示データの文字化け等）不具合の修正
- 論理削除行をグレー表示をメニューから操作したときにアプリケーションが停止（スタックオーバーフロー）する不具合修正
- ERエディタでエンティティ定義CSV出力時に a5m2_FOREIGN_KEYS.csv に UPDATE_RULE,DELETE_RULE 列が追加されていなかったので追加(### Version 2.19.0 で追加予定だったもの)


### Version 2.19.0 2024/01/28
機能追加・変更
- 外部キーで ON DELETE, ON UPDATE を扱えるように（テーブル定義の変更・テーブルエディタ・テーブル定義書 の各機能にて）
- テーブル定義書・エンティティ定義書のレイアウトを修正
- テーブル定義書で Html 形式のデザインを修正
- タブのマウスオーバーで「最近使ったタブ」を7個までポップアップ表示する機能を追加
- フィルター機能の評価式の機能強化
- ファイル(SQL, ER図, DMS等)をデータベースへのお気に入りとして登録できるようにした
- SSH経由での接続時にSSH接続に使うIPバージョン(v4,v6)とSSHサーバーからDBサーバーへのIPバージョン(v4,v6)を分けて設定できるように変更
- Oracle で、使用可能なら DBA_XXX データディクショナリを使用するように変更(従来は ALL_XXX データディクショナリ)
- 論理削除された行を（条件式を指定することで）グレー表示する機能を実装
- ERエディタで、CREATE TABLE文のかっこの内側のオプション記述に対応
- ERエディタで、テーブル名・カラム名・データ型からリレーションシップを推定する機能を追加
- ERエディタで、シェイプオブジェクトに画像を張り付けるときに、絶対パスのほかに相対パスでもしてできるように変更(これまで同様、画像そのものはファイルに含まれない)


### Version 2.18.4 2023/08/19
機能追加・変更
- グリッド表示時にデータ中の改行コードを表示できるように修正
- ### Version 2.18.0 から SQLite への接続で排他モードになっていたのを排他モードにならないように修正
- CSVインポート時に文字列中の改行コードがすべてCRLFに変換されてDBに登録される問題を修正
- SQLでディタでDB選択プルダウンの幅を広くした
- JISコードのCSVインポートの最大サイズを10MB → 200MB へ変更
- SQLエディタのグリッドで右クリックメニューから現在日付・現在日時・NULL・0000-00-00 を入力できるように修正
- 進行中のトランザクションがある場合、「トランザクションの管理」ボタンの周りに赤枠が点滅するようにした。(～2.17系のように)
- トランザクションの管理フォームのUIを見直し操作が簡単に行えるようにした
- 一括エクスポート時にファイル存在チェックを行い、上書き確認を行うようにした
- テストデータ作成機能で PostgreSQL のジオメトリ型対応
不具合修正
- DBツリーのフィルタ実行時にマウスカーソルの位置によってはエラーが発生していた不具合の修正
- CSVインポート時に「SQLコマンドが正しく終了されていません」のようなエラーになる不具合を修正(### Version 2.18系の不具合)
- PostgreSQL でステートメントがタイムアウトするとスキーマやセッション変数がリセットされる問題を修正
- ### Version 2.18.0 ～ 2.18.3 でDBのパスワードが意図しない方式暗号化形式(Blowfish/初期化ベクタの扱いが古い形式)で保存されてしまう不具合修正(弱い暗号というわけではない)
- 読み取り専用のとき、Blobエディタでテキストがスクロールできなくなる問題の修正
- MySQLで set names コマンドを実行したときにその後うまくデータが取得できなくなる問題の修正
- PostgreSQLにて接続の切れたDB接続でSQLを実行しようとしたとき、エラーとなってSQLエディタの操作ができなくなる不具合修正(### Version 2.18.4 beta 2 からの不具合)
- 0 未満、-1.0 以上の 小数点以下１桁の数字の表現がおかしくなることがある不具合修正
- テーブルデザイン画面で、主キーのないテーブルのDDLがおかしい（空の主キーを生成しようとする）不具合修正
- ER図で循環参照のリレーションシップがある状態で、DDLの出力を依存関係順で出力しようとするとハングアップする不具合修正
- Microsoft SQL Server で rowversion(timestamp)型は値を指定してINSERT,UPDATE問題に対する修正(CSVインポート・テーブル設計・INSERT文生成・UPDATE文生成・テストデータ作成)


### Version 2.18.3 2023/06/18
機能追加・変更
- SQLエディタで、「全ての結果セットを Excel に出力」の挙動を「表示中の結果セットを Excel に出力」に近い挙動に修正
- 正式に Amazon Redshift 対応(文字化け修正・主キー・制約の列挙等)
- 各データベース登録ダイアログの横幅を広く変更
- テーブルエディタでビューやシーケンスを開いたとき、必須制約を参照しないように修正(デフォルト値が設定されている可能性があるため。必須制約のエラーはサーバー側に任せる)
不具合修正
- SQLServerのとき、DBツリーのスキーマで再読み込みボタンが表示されない不具合修正
- ERエディタでオブジェクトのサイズ変更をするとき、選択済みオブジェクトを優先することで、隣接するオブジェクトがある時でも意図しないオブジェクトが選択されてしまう問題を修正(操作性の向上)
- x86 版で x64 版 sqlite3.dll が同梱されていた不具合修正
- ### Version 2.18.0 以降で PostgreSQL において、EUC_JP のデータベースにつなげなくなっていた不具合を修正
- SQL Server で datetimeoffset が正しく扱われない不具合修正
- ### Version 2.18.0 以降で PostgreSQL において、timestamp with timezone 型を表示するとき、"+09:00" のようにタイムゾーン情報も出力(画面・CSV etc...) していたが、画面のみに変更(CSVはタイムゾーン付きだとExcel等で扱えなくなるため)


### Version 2.18.2 2023/05/13
不具合修正
- ### Version 2.18.0 からステートメント前のコメントもサーバーに送るようにしたが問題が多いようなので、ステートメント前のコメントは基本サーバーに送信しないように修正・PostgreSQL 向けとして、ヒント句のSQL ("/*+ … */" および、 "--+ …" のステートメント前コメントのみ例外的にサーバーに送信するように修正)
- 日本語環境以外で起動しようとしたときに、「起動シーケンス "起動モードの確認" でエラーが発生しました。:」と表示して起動できない不具合を修正しました。
- ERエディタで生成する疑似命令のコメントの行頭を "--*" から "-- *" に変更 (MySQL では-- の後ろに空白がないとコメント扱いされないことに合わせたもの)
- コロンの後ろに数値が来る文字列がある場合、コロンと数字の間に空白が挿入される不具合を修正


### Version 2.18.1 2023/05/07
不具合修正
- マイクロソフトストア版として実行したときにワークスペースの設定(ワークスペース画面を起動時に表示するかなど)が保存されない不具合を修正


### Version 2.18.0 2023/05/04
機能追加・変更
- テーブル定義書・ER図のエンティティ定義書でマークダウン形式で定義書を出力できるようにした
- SQL整形で、「改行桁数」・「カッコ内が長い場合に改行する桁数」を追加
- SQL整形で、JOIN … ON で ON を JOIN の行の末尾に配置するオプションを用意
- グリッド上でCtrl+↓(↑)でセルの値が異なる行まで移動する機能を実装
- グリッド上でジオメトリデータ型で、「…」ボタンからマップへ遷移できるように変更
- キーワードの自動大文字化機能実装(デフォルトOFF)
- 複合語命名規則（スネークケース（大文字）・スネークケース（小文字）・パスカルケース・キャメルケース）の相互変換機能を実装
- キーワードの大文字化・小文字化機能の実装、識別子の大文字化・小文字化機能の実装
- SQL実行エラー時のダイアログをコピー機能付きの独自ダイアログに変更
- SQLエディタ・テーブルエディタでフィルター使用時にフィルター適用前の全件数を表示するように修正
- Microsoft SQL Server で Money 型を小数点以下２桁まで表示するように修正
- DMonkeyスクリプトでメソッドの引数チェックに誤りがあり、しばしばメモリの読み込み違反になっていたのを修正
- ER図のエンティティ定義CSVでドメイン定義CSVが、エンコードを指定していても常にShift_JIS(MS932)で出力されてしまう不具合修正
- SQL入力支援機能を改善
- コードスニペット機能を実装
- DBツリーで「スキーマ」のノードで「カレントスキーマを変更」ボタンを追加
- DBツリーで「データベース」のノードでトランザクション制御や再読み込みのボタンを追加
- テーブルエディタやSQLエディタで結果セットを更新した時のSQLをログファイルへ出力するように修正
- SQLの区切りがセミコロンのモードで、セミコロンの直後にキャレットがあった場合、直前のSQLを実行するように変更
- ERエディタで、エンティティの属性で有効/無効を切り替えられるようにした（一時的に存在しないカラムとして扱う）
- Ctrl+H でも置換ダイアログが使えるようにした（SQLの実行履歴は Shift+Ctrl+H に変更）
- ワークスペースの切り替え機能実装
- Oracleでパスワード有効期限が迫っているときにログイン時に警告表示を行うように修正
- インデックスのオプションを扱えるようにした(現状 PostgreSQL のみ。PostgreSQL の 部分インデックスとか)
- PostgreSQLおよび、MySQLでSQL実行時にエラーが起きた場合、エラー位置の単語を選択するように修正(これまで Oracle のみ実装されていた)
- トランザクションの管理（接続中DBに対してトランザクション開始/コミット/ロールバックする機能）画面を追加
- Wine (LinuxやMac) 上で、OKボタンとキャンセルボタンの位置を入れ替える機能を実装


### Version 2.17.4 2022/09/17
機能追加・変更
- SQLスクリプト実行時にログファイルが排他ロックされるのを共有ロックに変更
- OpenTopoマップの最大ズームレベルが15に変更されていたことの修正

不具合修正
- ER図のエンティティ定義CSVでドメイン定義CSVが、エンコードを指定していても常にShift_JIS(MS932)で出力されてしまう不具合修正
- DMonkeyスクリプトで引数チェックに誤りがある不具合を修正
- ER図でSQLタグに移動したときにエラーが発生する不具合を修正
- JSON出力でBCDとして扱われる型が文字列扱いになっていた不具合を修正
- 初回起動時にレジストリ・ポータブルモード選択画面で終了を選んだ時にエラーが発生する不具合修正
- PostgreSQLでストアドプロシージャランチャが実行できなくなっていた不具合を修正
- PostgreSQLでパーティショニング子テーブルが、親テーブルと違うスキーマにある場合、親スキーマのテーブルが列挙できなくなる不具合を修正
- Print Spooler サービスが停止している場合にエラーとなる不具合修正
- PostgreSQL Compatible with Oracle対応
- SQLスクリプト実行のログがCRLFLFになってしまう不具合修正
- Oracle でCSVインポート時にNUMBERの精度が低くなる不具合を修正


### Version 2.17.2 2022/05/09
機能追加・変更
- PostgreSQL, MySQL のジオメトリデータ型で、「…」ボタンからマップへ遷移できるように変更
- Ctrl+↓(↑)でセルの値が異なる行まで移動する機能を実装。Shift+PageUp(PageDown), Ctrl+Home(End)でのデータセットの先頭・末尾への移動を実装。
- テーブル一覧を一覧する画面で、パーティション子テーブルを列挙しないように変更

不具合修正
- クエリー直後に全てフェッチしないモードのとき、全件フェッチの時間が 0 になる問題を修正
- ### Version 2.17.0 あたりからテーブル条件の Like 検索が効かなくなっていた不具合を修正
- PostgreSQL で複数行インサート使用時にftTimestamp 型のパラメータのミリ秒が欠落する不具合修正
- MySQL のテキスト型を Clob ではなく文字列型として扱うオプションがONになっていると、長さが65535バイトに制限されてしまう不具合対策として、オプションのデフォルト値を修正
- 通常モード利用時（レジストリに設定データを保存するモード）にオプション画面の「デフォルトに戻す」ボタンが効いていない不具合修正
- マークダウン形式でコピーするとき、ftFmtBCD 型が左寄せになってしまう不具合修正
- その他いくつかの画面のレイアウト微修正


### Version 2.17.1 2022/01/27
機能追加
- テキストエディタコンポーネントでの非選択時のコピー・切り取りで現在行のコピー・切り取りする機能の実装
- ### Version 2.17.0 で削除したMDIをオプション扱いで復活（メニューから [ウィンドウ(W)] - [MDI（サイズ変更可能な子ウィンドウ）を使用する(M)] をチェック）
- SQLエディタで結果セットをInsert文としてコピーする機能を追加

不具合修正
- DDL生成時にER図の列でコメントが空でもコメントを生成するように修正
- ログインダイアログで「本番環境」接続時にチェックボックスをチェックしないとログインできないように修正
- /Connect オプションでトーストを表示しようとしたときにメイン画面が初期化されていないためエラーになる不具合修正
- ER図のヘッダ・フッタの入力がうまくいかない不具合修正
- ER図の定義CSVでドメインCSVの出力に誤りがあったのを修正
- 英語リソースへの切り替えが上手く行っていなかった不具合修正
- 英語リソースへの切り替え時に高DPIの切り替えがおかしくなる不具合対処
- タブのShift+マウスオーバーでタブのプレビューする機能をキー入力時の誤作動をしにくい実装に修正
- オプションダイアログ中のSQLのキーワード編集画面のスペルミス修正およびデザイン変更・文字入力の改善
- テーブルディタで条件指定のキャンセル時に再検索されてしまうのを修正


### Version 2.17.0 2022/01/23
- 画面デザイン（アイコン等）の刷新
- MDI制御で、MDI子フォームを常に最大化するように修正
  (より一般的なタブインターフェイスに近い制御に)
- PostgreSQLの管理者ツールを追加
  (パラメータ・パフォーマンスグラフ・セッション・ユーザー管理)
- Excel出力・グリッドのコピー時に偶数行の色を変えるオプションを追加（デフォルトOFF）
- ER図のドメイン機能で、カラムの物理名を管理する機能を追加
- 表示中の結果セットから、右クリックメニューで、 [SQLの実行計画を表示(Q)...] を追加
- ERエディタで、表示中のページをWindowsの壁紙に設定する機能を追加
- テーブルをinsert/update文でコピーする機能の改善
  (タイムスタンプ・日付・時刻はフォーマット指定不要に変更/バイナリデータ型対応/Geometry型対応/"N''" 形式の国際化文字列対応)
- 結果セットのコピー機能で、JSON形式・DbUnit形式に対応
- WHERE句のないUPDATE/DELETE文を実行しようとしたときに確認メッセージボックスを表示するように改善
- 本番環境などでクエリー以外のSQLを実行するとき、確認ダイアログを表示できるように修正
- SQLiteで桁数・精度の指定されない decimal 型の場合、小数点以下が表示されなくなる不具合を修正
- デザイナ画面で、 一部DB製品使用時にテーブル名に日本語名などが含まれているときにテーブル追加でエラーになる不具合を修正
- SQLのデザイナ画面で、OK押下時に日本語などをのテーブル名やカラム名をクォート処理するように修正
- DBにER図を割り当てた後、ER図ファイルを削除（あるいは移動）すると、ER図の割り当て解除ができなくなる不具合を修正
- PostgreSQLで外部キーを列挙するのが遅い問題を修正
- カラム名がDBの既定の大文字・小文字と異なる場合、インポートなどでエラーになる不具合を修正
- ER図関連でバグ関連の互換性制御を行う画面を用意
- オブジェクトソースのリバース生成機能などで、Oracle でファンクションのソースがうまく取得できない不具合を修正
- ER図のエンティティをコピーして別のER図に張り付けたときに位置が崩れる不具合を修正


### Version 2.16.2 2021/10/05
- SQLエディタで実行時間の短い多数のSQL連続実行時に他のタブへの切り替えに支障が出る不具合修正
- SQLエディタのSQL停止ボタンで最初の２秒間は現在実行中のSQLの停止を待つように修正
- SQLエディタで「SQLを実行し、結果セットをグリッドではなくCSV/TSVファイルに出力」をしたときにTSVを選択してもCSVで出力される不具合修正
- テーブルエディタでinsert/update文コピー時にダイアログタイトルバーがおかしかったり、チェックボックスの有効・無効がおかしかったりする不具合修正
- テーブルエディタの右クリックメニューの「ソート条件の指定」が効いていない不具合修正
- デザイナ画面で一部RDBMS製品使用時、テーブル名に日本語名などが含まれているときにテーブル追加でエラーになる不具合を修正
- デザイナ画面でクエリー実行時に、長い文字列が `(memo)` 等と表示されてしまう不具合を修正
- テーブルの再設計機能で、MySQLのauto_increment型を使ったとき、生成されたSQLを実行すると #42000 エラーになる不具合を修正
- ER図の読み込みが失敗したときに、ER図の割り当て解除ができなくなる不具合を修正
- 高DPI環境下でのデザイナフォームの初期サイズ調整
- ER図を割り当てたときに大文字小文字の違いでカラムの論理名やコメントが正しく取得できない不具合を修正
- MySQLでコメントの編集ができない不具合修正
- テーブル定義書の出力で制約が正しくHTMLされていなかった（レイアウト崩れ）不具合修正
- MySQLで decimal(m,d) unsigned 形式のデータが正しく表示できない不具合を修正


### Version 2.16.1 2021/07/25
- マップ表示で WebView2 コントロール(Microsoft Edge Chromium版のコンポーネント)がインストールされている場合、それを使用するように修正
- SQLエディタのデザイナ画面で、「オブジェクトの追加」を行うと、「nil を TsizeConstraints に代入することはできません」エラーになってしまう不具合修正
- 連続インポートでCSV/TSVを切り替えても、スキーマ名のつかないファイル名の拡張子がダイアログ表示上TSVにならない不具合の修正
- 一括エクスポートで、拡張子をjsonにすると、表示上のファイル名が僅かに見切れるせいで、"jsor" に見えてしまう表示上の不具合修正
- 起動時に前回使用時の画面の幅・高さ・DPI値のいずれか異なる場合、DBツリーの幅を復元しないように修正


### Version 2.16.0 2021/06/26
SQLエディタ
- SQLファイル等で、ファイル保存時に改行コードを選択できるように変更
- SQLエディタで、Escキーで入力補完ができるように(F4による入力補完は廃止)
- SQLエディタで、SQLを書式付きでコピーする機能を実装
- SQLエディタのオプションで「タブの幅を文字数ではなく表示幅から計算する（等幅フォントのみ）」を追加 （デフォルトOFF）

テーブルエディタ
- SQL生成の画面で、カラムコメントを付加するか指定できるオプションを追加
- いくつかのDBでDB接続時に初期スキーマを指定できるように改善

ER図
- ERエディタで、エンティティを一つだけ選択している場合、それに紐づいているリレーションシップの線を太く（見やすく）表示するように修正
- ERエディタで「@BOOLEAN」ドメインを追加（DB製品によっては1バイトや１ビットの整数型になることがあります。）

その他
- 高DPI環境下でテーマ機能を使ったときの見た目を改善
- 結果セットからINSERT文でコピーする機能において、PostgreSQL, MySQLのバルクインサート形式でコピーできるように改良
- insert文でエクスポートする機能を実装(Oracle, SQLServer, Db2, PostgreSQL, MySQL, SQLiteのみ)
- 起動時パラメータを実装(/DelDB, /DelAllDB, /Exit)
- PostgreSQLでタイムゾーンがUTCになってしまう場合がある不具合修正（接続時に明示的にタイムゾーンを設定）
- MySQLで接続時のタイムゾーンを設定するように修正
- ERエディタでPDF出力機能を追加(メニューから [ファイル(F)] - [PDF出力...])
- Shiftキーを押しながらタブ上をマウスオーバーしたときにタブの内容をプレビュー表示できる機能を実装
- Wineを使用しての Linux, Mac OS での動作を改善
- テーブルエディタ・SQLエディタで実際のデータ幅に合わせてグリッドの列幅を調整する機能（ボタン）を実装
- EditorConfig対応
- グリッドでデータが WebColor("#FFFFFF" 形式や "Red" などの色)の時、実際の色を表示する機能を実装（デフォルトON）
- MySQL, MariaDB で Geography 型対応（WKT形式での表示）
- DBツリーからSQLエディタへテーブル名をドラッグ＆ドロップした際に「SQL文の貼り付け」と「CREATE TABLE文の貼り付け」を行える機能を実装
- Replace疑似命令の実装


### Version 2.15.5 2021/03/21
- 英語モードで実行したときにCSV/TSVインポートが正常に動作しない不具合を修正
- PostgreSQL(他のDBでも起こる可能性あり)で、0.1～0.9の小数点以下１桁の数字が0と表示されてしまう不具合を修正(### Version 2.15.3以降の不具合)
- PostgreSQL でビューのソースに"CREATE VIEW"が付かない不具合を修正
- PostgreSQL で複合主キーの順序が不正になる不具合を修正(### Version 2.15.3以降の不具合)
- ERエディタのリレーションシップのプロパティ画面で、カラム名に空白があるときに２つ（以上）のカラムとして扱われてしまう不具合を修正
- OracleのXMLTYPEが仮想列扱いとなり更新できなくなっていた不具合を修正


### Version 2.15.4 2021/01/17
- Oracleで複数行インサート(CSVインポート・ダミーデータ作成・データポンプ等)を使うと日付時刻型でミリ秒がロストしてしまう不具合を修正
- MySQL 4.0 を使ったときにテーブル名の後ろに空白が付加されてしまう不具合を修正
- テーブル設計画面で出力されるDDLで、テーブル名のエイリアスに "old" を使っていたが、一部の環境で問題があるため、"org" に変更
- インターネットに接続できない環境で使用した場合、バージョンチェック（最新チェック）が正しく終了せず、A5:SQL Mk-2が正しく終了できない不具合を修正
- リモートデスクトップ接続された場合などで、メインディスプレイのDPI値が変化した場合、データベースツリーがおかしくなる不具合を修正
- 実数型で小数点以下が正しく表示できないことがある不具合を修正


### Version 2.15.3 2020/11/22
- PostgreSQL で接続時にタイムゾーンがUTCになる問題の修正
- MySQL で接続時にタイムゾーンがシステム設定に依存（しばしばUTC）になる問題の修正
- スキーマの比較機能でテーブル名の比較がうまくいかない不具合の修正
- PostgreSQL で主キーの取得の仕方を変更(カラムの追加・削除直後に主キーが正しく取得できないことがある不具合の修正)
- PostgreSQL でshowコマンドが実行できなくなっていた不具合を修正
- MySQL 4.0 以前でテーブルエディタやSQL入力支援などでテーブル名の後ろに空白がついてしまう不具合を修正


### Version 2.15.2 2020/10/04
- PostgreSQL のGeometry型強化(Geometry型をEnhanced WKT形式で表示できるようにした)
- PostgreSQL のGeometry型の地図表示強化
- 「SQLを作成」の画面で、コメントを生成しないオプションを追加
- ER図を割り当てたときにテーブルコメントがうまく表示できないことがある不具合を修正
- PostgreSQL, MySQLでSSL関係のオプションを復活
- MySQLのtimestamp型でデフォルト値の扱いを修正
- PostgreSQL で "select from テーブル名" のSQLを実行したときにプロトコルエラーになる不具合対処（暫定）
- ### Version 2.15系で、オプションの「データベースに Keep alive を送信」がチェックOFFになっていても有効になっていた不具合を修正


### Version 2.15.1 2020/07/25
- PostgreSQL のGeometry型対応(Geometry型をWKT形式で表示できるようにした)
- PostgreSQL のGeometry型で地図に表示できるようにした
- PostgreSQL のpublicスキーマをクォート処理しないように変更
- PostgreSQL で読み取り専用モードのとき、set transaction_read_only = onを実行するようにした。
- PostgreSQL でユーザー定義型(geometryとか)を正しく取得できるように修正
- PostgreSQL でSerial型として定義したデータ型をIntegerではなく、Serialとして表示できるように修正
- Shift+DelでNOT NULL項目はNULLにしないようにした。
- PostgreSQLでSerial型の時にテーブルエディタで値要求されてしまう不具合修正
- キーの中にAAABBの列あったとき、BBの列名が主キー扱いになってしまう不具合修正
- 小文字を含むテーブルが正規表現で検索できなくなっていた不具合修正
- PostgreSQLで外部キーの列挙が辞書順になっていなかったのを修正
- DDL生成時に「キーワードに大文字を使う」をチェックしているとカラム名が大文字化してしまう不具合を修正
- ダミーデータ作成で列長さのチェックがOracleの場合に１つずつずれる（テーブルエディタではROWIDを隠しカラムとして持つため）不具合を修正


### Version 2.15.0 2020/05/31
- テーブル設計画面を追加(テーブルの新規作成・レイアウト変更画面)
  ブログ記事参照 → https://a5m2.mmatsubara.com/wp/?p=4404
- 結果セットの一括更新機能を追加（複数行の変更をまとめて送る機能・デフォルトはOFF）
- ERエディタの改善
   → ER図でリレーションシップの線種として、線を自由に引くことのできる「自由結線」モードを追加
   → ERエディタでAltキーを押しながらオブジェクトを移動することでグリッドに合わせてオブジェクトを配置するように変更
   → ER図のDDL生成で、予約語を大文字にするオプションを追加
- スキーマ間のデータ転送でテーブルを指定できるように変更
- SQLエディタで実行時にSQLの区切りを検出し、「"/"のみの行」や「"GO"のみの行」に切り替え（確認メッセージあり）る機能を追加
- 数千テーブルあるような環境でのSQL入力支援機能の高速化
- json形式のエクスポートを実装
- Microsoft SQL Serverかつ、MERGE文の実行のとき、区切りのセミコロンを除去しないでサーバーに送るように修正
- 高DPI環境下の表示を改善
- テーマカラーのデフォルトを「薄灰桜」に変更
- DML文でテーブルエリアスを使った構文でも入力支援が使えるように修正


### Version 2.14.5 2019/11/16
- PostgreSQL 12対応
- ### Version 2.14.0以降でPostgreSQLでDML(INSERT,UPDATE,DELETE)の実行計画を取得すると実際に実行されてしまう不具合を修正


### Version 2.14.4 2019/09/xx
- ### Version 2.14.3で発生していたSQL入力支援の不具合修正
- MySQLでVERBINARYが文字列型として認識されてしまう不具合修正
- SQLServerでViewの定義書がうまく出力できない不具合を修正(カラムが出力されない)
- SQL整形で全角文字があるときの１行コメントの位置がずれてしまう問題を修正
- テーブルエディタからExcel出力時にシート名のエラーになることがある不具合を修正


### Version 2.14.3 2019/08/12
- 数千テーブルあるような環境でのSQL入力支援機能の高速化
- テーブルエディタで初期値が指定されない場合(NULL)の場合、デフォルト値で置換して挿入していたのを修正
- ERエディタでビューのSQL編集時に入力支援で論理名が出てこなかった不具合を修正
- SQLエディタとテーブルエディタからCSV出力時に件数を表示するように修正
- ERエディタでテーブル生成順序を「依存関係順（依存するほうが先）」に設定するとエラーを起こすことがある不具合を修正
- PostgreSQLでMONEY型の扱いに誤りがあった問題を修正(日本語設定のPostgreSQLサーバーの場合に1/100の値で表示される)
- ストア版では、拡張子の関連付けを行えないように修正


### Version 2.14.2 2019/07/04
- ER図をデータベースに割り当てているとき、ER図の論理名をうまく取得できない不具合を修正
- MySQLでエンコーディングがUTF8MB4のとき、サロゲートペアが正しく扱えない不具合を修正
- ### Version 2.14.0からスキーマ間のデータ転送機能でがNULLが、''に置き換わっていた不具合を修正
- ### Version 2.14.0からダミーデータ作成機能でNULLが、''に置き換わっていた不具合を修正
- 英語モードで使用したとき、テキストエディタのタブを表す文字が化けてしまう不具合を修正
- SQLエディタで補完ウィンドウをマウスでリサイズすると、フォーカスが補完ウィンドウに移動してしまう不具合を修正
- SQLエディタで、ストアドプロシージャモードへの切り替えをする判定ロジックを改善
- SQLエディタで、キャレット位置のテーブル名をテーブルエディタで開くとき、DB接続が無い場合、DB接続ダイアログを開くように改善
- SQLエディタ・テーブルエディタでフィルタにコメントを書くとエラーになる問題を修正
- Microsoft SQL ServerでMERGE文を実行するとき、SQL区切りのセミコロンを除去しないように改善
- 主キー・ユニークインデックス・ユニーク制約のないテーブルをテーブルエディタで開いたとき、更新ができないように変更
- テーブルエディタでNOT NULLかつデフォルト値がある列に、値を指定せず行を登録できなかった問題を修正
- 「'」や「(」などの入力時、文字列選択状態で括る機能を「オートブラケット（括弧や括り記号の補完）を行う」がONのときのみ動作するように変更(これまでは常に動作していた)
- CLOBとして認識される型で「条件を指定して開く」が正しく動作しないケースがある不具合を修正
- SQLエディタで「すべての結果セット全体をコピー」でオプション設定が効いていない不具合を修正


### Version 2.14.1 2019/03/23
- SSH接続ライブラリを Version 9.0.1 → 9.0.2に更新
- 英語モードで利用時にCSVインポートを行うとエラーが発生する不具合を修正
- SQLiteでload_extension()が動作しない問題を修正
  （DB登録の画面で、「"load_extension()"を有効化する」をチェックする必要があります。）
- 「テーブル」オプションの「ソート順とフィルター条件を保存する」のオプションをONにしているときに、ソート順に指定されている列（多くの場合主キー）がテーブルレイアウトから削除されると、テーブルエディタで開くことができなくなる不具合を修正
- Captionsディレクティブ（疑似命令）で半角空白があると、そこで列のキャプションが区切られてしまう不具合を修正
- Microsoft Store対応
- 単精度浮動小数点のデータを表示したときに一旦倍精度に変換される関係上、誤差が表示されていた不具合を修正
- PostgreSQLで外部キー制約が表示されなくなっていた不具合を修正


### Version 2.14.0 2019/01/26
- Excel出力したりコピーしたりするとき、NULLを「« NULL »」に変更。
  （これまでは「Zero Width Space」を含んだ文字列を使っており、分りにくいことから、しばしばトラブルのもととなっていた）
- MySQL 8.0対応
- Netezza(IBM PureData for Analytics)対応
  (ODBCドライバを使用して接続)
- グリッドで Shift+DELを"NULL の入力"としていたのを、"NULLまたは空文字の入力"のトグル動作に変更
- CSVインポート・テストデータ作成機能・スキーマ間データ転送機能を高速化（複数行インサート）
- データベースツリーのテーブルの並び順でASCIIコード範囲内の並び順をすべての記号・数字・アルファベットに変更（全角は影響なし）
- 一括エクスポート・連続インポートで途中でキャンセルできるように修正。
- ER図の保存時にZOrderを変更するとファイル保存時の並び順が変わっていたのを変わらないように修正（ZOrderプロパティの導入）・ER図でDDL作成時にCREATE TABLEの作成順序を制御できるようにした
- SSH接続時のローカル側待ち受けポート番号を指定できるようにした
- 細かな修正


### Version 2.13.3 2018/09/17
- MySQL で「autocommit=0」に設定されていると、A5:SQL Mk-2のトランザクションがうまく動作しない不具合を修正
- Microsoft SQL ServerとMySQLのデータベース登録ダイアログで、パスワードが空のとき、データベース一覧のコンボボックスが読み込まれない問題を修正
- SQLエディタでOracleのエラーのあるCREATE PROCEDUREを実行すると「リストのインデックスが範囲を超えています (0)」エラーが起こる不具合を修正
- DBツリーのダブルクリックで「条件を指定して開く」を使っているときに条件ダイアログでキャンセルするとエラーになる不具合を修正
- 黒系のテーマ使用時にデータグリッドが見にくくなる不具合を修正
- スケールが100%でないディスプレイでMicrosoft AccessとSQLiteのデータベース登録画面の一部のボタンが表示されない不具合を修正
- SQLエディタで「ルールを指定してソース文字列を生成」のショートカットが効かなくなっていたため、ショートカットを Shift+Ctrl+Alt+0 に変更
- SSH接続時に32bit版のみ（？）で「SSHトンネル用のローカル空きポートを見つけられませんでした」エラーになる不具合を修正
- マルチバイト文字列に対応しないOSで起動時にアドイン機能の読み込みエラーになる不具合を修正
- SQLの入力支援で一部コメントが表示されない不具合を修正


### Version 2.13.2 2018/06/19
- ERエディタで自己参照のリレーションシップが選択できなくなっていた不具合を修正


### Version 2.13.1 2018/06/16
- テーブルからの「クエリーの生成」機能で、SQL中にコメントを記述するかのオプションを追加
- 高DPIの環境(ディスプレイの表示が100%より大きい環境)でER図プロパティがレイアウト崩れする不具合を修正
- ERエディタでページ（タブ）の順序をドラッグ＆ドロップで変更できない不具合を修正
- オプション値でDBコメントを論理名とコメントに区切る方法の正規表現が正しく保存できていなかった不具合を修正
- SSH接続を複数行うと、最初に接続したデータベースに接続しようとしてしまう不具合を修正
- テーブルエディタで「件数制限なしで再取得」が正しく動作しない不具合を修正
- Dropboxのフォルダなどでポータブルモードで運用すると、Setting.ciniへのアクセスが失敗するケースがある問題の修正
- SQLを作成ダイアログで「SELECT文で行コメントから列キャプションを決定する」チェックボックスを追加
  (行コメントがあるとSQL実行に失敗する環境があることへの対策)
- ER図でページをまたぐリレーションの操作ができなくなっていた不具合を修正


### Version 2.13.0 2018/05/13
- Delphi を Delphi 10.2 Tokyo に更新
- UniDAC を Version 7.1.4 に更新
- SecureBridge(SSHライブラリ)のバージョンを 8.0.1 → 8.1.2 にバージョンアップ
- Oracle, DB2, PostgreSQLでマテリアライズドビューに対応
- 登録データベースのエクスポート＆インポート機能を追加（パスワードはエクスポートされません）
- x64盤のみMongoDBに接続できるように…（仮対応・将来対応しなくなる可能性があります）
- ERエディタでB2, A1の用紙サイズを追加
- 括り補完(閉じ括弧の自動入力)を追加（デフォルトでOFFなので、オプションダイアログのSQLエディタタブからONにする必要があります）
- ポータブルモードでSQLのログを取るとき、オプションからログを暗号化しない設定にできるようにした。
- DBごとに色を登録できるようにした。（DBツリーやタブ、DB選択のプルダウンなどで色を表示）
- DROP TABLEでBackupToTempTable疑似命令を書くことで一時的なテーブルにデータを保存するようにした。
- CREATE TABLEでRestoreFromTempTable疑似命令を書くことで一時的なテーブルからデータをロードできるようにした。
- 疑似命令CaptionListとCaptionFromCommentを追加
- タブ切り替えのスピードボタンを追加
- システムのサスペンド時にDBをすべて切断するように修正（オプションで無効化可能）


### Version 2.12.3 2017/10/21
- DB2/400への接続の改善（SQL入力支援時にテーブルやカラムの論理名を取得したりなど）
- ERエディタでビューオブジェクトに共通列が表示されていた不具合を修正


### Version 2.12.2 2017/09/02
- BLOBエディタの操作性改善
- Oracle直接接続でサロゲートペア文字などが化ける問題の修正
- SQL Server直接接続時にDateTime2型でExcel出力が失敗する不具合修正
- CSVファイル出力時にバイナリ項目をオプションダイアログのエンコーディングで出力できるように修正
- タスクバー周りの動作の修正（モーダルダイアログやメッセージボックスの表示時の動作改善）
- SSH経由での接続時にPLINK.exeを使用できるように修正(Version 2.12.0からPutty形式の鍵ファイルでもPLINKを使わないようにしていた)
- DB2/400への接続の改善（SQL入力支援時にテーブルやカラムの論理名を取得したりなど）


### Version 2.12.1 2017/06/06
- SQLエディタで時間のかかるSQL実行中にフェッチ件数などを表示するように修正
- FirebirdのUTF8環境において、日本語が正しく扱えない不具合を修正
- CSVのインポートでUTF-8のファイルを読み込むとき、「unicode 文字のマッピングがターゲットのマルチバイトコードページに存在しません」のエラーが出る不具合の修正
- SQL Serverのインポート機能で、IDENTITYが指定されているテーブルでエラーになる不具合修正
- ER図のエンティティのプロパティで、データ型のヒント表示がうまくいかない不具合を修正
- 64bit版でSQLの連続実行時で「結果セット最大変数」以上の結果セットがあった場合、次のSQL実行が失敗する不具合を修正
- 「起動時に前回終了時のファイルの状態を復元する」機能で、A5M2.exeの存在するフォルダ名を変更するとうまく復元できない不具合を修正
- SQLエディタでInsert文エクスポート機能で、スキーマ名の無いテーブル名のSQLなどでうまく動作しない不具合を修正
- ### Version 2.12.0で高DPI環境下で表示が崩れる問題を修正
- DB2の新しいODBCドライバ名に対応(v11.1等)
- PostgreSQLのText型をデフォルトで文字列型ではなく、CLOB型として扱うように修正
　（オプションダイアログから変更可能）


### Version 2.12.0 2017/04/09
- グリッド表示で奇数行・偶数行の色を変えて見やすくした
- データベースで、「コメント」に「テーブル名（又は列名）」と「コメント」を入れるとき、タブ文字または改行のみを区切り文字としていたのを、「:」, 「,」, 「;」を区切り文字として使用できるようにした。また、区切り文字をオプションダイアログから選択できるようにした。
- SQLエディタで複数の結果セットを表示しているとき、Ctrl+PageUp, Ctrl+PageDownで結果セットのタブを移動できるようにした。
- テーブルエディタとSQLエディタの結果セットで、Shift+マウスクリックで範囲選択を行えるようにした。
- テーブルエディタで選択範囲をInsert文でコピーする機能を追加
- 異常終了後の起動で前回のセッションバックアップを復元する機能を追加
- SQL Server接続でSQLClientがインストールされていなくても接続できるようにした
- SQL Server 接続時に暗号化(SSL)して通信可能にした
- SQL Server/Interbase/Firebird接続時にポート番号を指定できるように修正
- ERエディタでDDL生成時にDBコメントに「テーブル名（又は列名）」と「コメント」を入れるとき、タブ文字または改行のみを区切り文字としていたのを、「:」, 「,」, 「;」を区切り文字として使用できるようにした。
- ERエディタで、リレーションシップの線の引き方で、直線（自動）, 直線（縦 端子）,直線（横 端子）を追加
- ER図リバース生成と同期(DB→ER図)でDBのコメントの取り扱いが異なっていたので統一
- SQLエディタで選択中の単語（又はキャレット位置の単語）をテーブル名とみなしてテーブルエディタを開く機能を追加
- SQLエディタで結果セットからInsert文を作る機能を追加
- テーブルエディタで結果セット件数が大きすぎて全権取得できない場合、「件数制限なしで再取得」できるボタンを追加
- SSH接続で、SSH鍵ファイルのパスフレーズ（あるいはユーザーパスワード）を内部的に保存しなくても良いように修正
- MySQLの0000-00-00対応
- SQL整形機能を更新(よくある 2Way-SQLツールのコメント対応・カンマやAND, OR の位置を式の前・後ろに移動するとき、行コメントとの位置関係を修正して整形)
- オプションでバイナリ項目の初期表示方法を選択できるように変更
- MySQLでTEXT型をCLOBではなく通常の文字列型として扱えるように修正
- PostgreSQL で SQL_ASCII のDBへの接続時にエンコーディングを強制的に指定できるオプションを追加
- CSVの読み込みにおいて、日付時刻型で ISO8601 形式の読み込みに対応
- BLOBやその他バイナリ項目の扱いを修正（統合）した。（表示・コピー&ペースト・CSVインポート/エクスポート・XMLエクスポート） 
- 64bit版でSQLite接続時にクライアントライブラリ不要とした
- SQL接続ライブラリ・SSHライブラリのバージョンアップ
- 英語版リソースを準備


### Version 2.11.7 2017/02/26
- A5:SQL Mk-2 の Version 2.11系でPortableモードの起動パスワードの扱いに不具合があったのを修正
　（関連して、設定ファイルの暗号ファイルフォーマットバージョンを更新）
- 細かな修正


### Version 2.11.6 2016/07/21
- テキストエディタ部（SQLエディタ・スクリプトエディタ）で行番号のクリック・ドラッグで行選択を行えるようにした
- テーブルエディタからinsert文エクスポートを行うと、BOOLEAN型が0,1になってしまう不具合修正
- 明示的にデフォルト値が指定されているテーブルでテーブルエディタからの更新時に値が書き換わる不具合を修正した。
- PostgreSQLで「9999/12/31 23:59」等が「9999/12/31 23:59:00.000004」等に化けてしまう不具合を修正
- SQL実行結果で一部実数型のマイナス値などが、指数表示になってしまう問題を修正。
- MySQL, PostgreSQLでTEXT型のコピーがうまくいかない不具合を修正。


### Version 2.11.5 2016/05/11
- Oracleにおいてメタデータ（テーブルの一覧やカラムの一覧）取得を若干高速化
- ### Version 2.11.4において、Oracleで複合主キーのテーブルにおいて、高い確率で制約の情報を取得出来ない不具合の修正
- バイナリ項目の Excel 出力時に意図しない表示形式で出力される不具合を修正
- URLの移転に伴い、オンラインヘルプやホームページを開くメニューのURLを変更
- SQLの整形時にパラメータをうまく成形できなくなっていた不具合を修正
- 常に手前に表示のウィンドウがモーダルダイアログより前に来てしまう不具合を修正


### Version 2.11.4 2016/02/15
- ### Version 2.11.3においてOracleで、V$SQLなど、いくつかの動的パフォーマンスビューをクエリーするとOracleの内部エラーが発生する不具合を修正。


### Version 2.11.3 2016/02/11
- ERエディタでViewを使うとき、特定条件下で列情報の生成で不要な列を列挙してしまう不具合を修正した。
- SQLiteでデータベースの登録画面でパスワード欄を利用不可にした。
- SQL Server, PostgreSQL, MySQLでトリガー情報が取得できるようにした。・HTMLコピー、Excel出力時にBLOB型の出力方法をテーブルエディタやSQLエディタのBLOB表示形式と同じ出力方式（エンコーディング）に統一した。
- フィルタ機能で、「項目名 = 'ABC*'」のような形式で部分一致検索にならないようにした。
- Interbase/Firebirdでの接続時にキャラクタセットとして「UTF8」と「NONE」をリストに追加
- 終了時に未確定のトランザクションがあるときに確認するメッセージボックスが効いていない不具合を修正した。
- SQLエディタ・テーブルエディタで小数点以下を桁そろえして表示しているとき、CSVも小数点以下を桁そろえして出すように修正。
- テーブルエディタ・テーブル定義書作成・テーブル定義CSV出力でテーブルの制約情報（主キー制約・一意制約・チェック制約）を出力できるようにした。(Oracle, SQL Server, DB2, PostgreSQL, MySQL)
- クエリーデザイナでSQLの前に記述されるコメントや空白が削除されないようにした。
- クエリーデザイナで初期表示の画面サイズを大きくした。
- テーブルエディタでソート画面で指定できる項目数を5→15に増加した。
- オプション画面でテーブルエディタの初期表示タブに「トリガー」と「ソース」を追加
- Excelへの出力や結果セットのコピー、テーブル定義書やエンティティ定義書の色の扱いがばらばらだったのを統一。(オプションで色は変更可能)
- Interbase/FirebirdでInterbaseクライアントがインストールされた環境でFirebirdに接続しようとしたとき、エラーが出る対処として、クライアントライブラリを指定できるようにした。
- データベースツリーでCtrl+Cで、テーブル名などをコピーできるようにした。
- 複数結果セットから大量の結果セットをExcel出力しようとしたときに「Excelに出力する行が多すぎます」のエラーが出る不具合を修正した
- Oracle 12cでコントロールパネルを操作時にユーザー作成のボタンが押下できない不具合を修正した。
- MySQLへの接続時に「SET SESSION binlog_format='MIXED'」を実行しないようにした。
- CLOB系のデータ型などでごく長い文字列が正しくグリッドに表示されない問題を修正した。
- SQLパラメータ設定画面で「NULL」にチェックが入ってるパラメータを設定し、スクリプトのapplication.getParameters()を使用すると「Null型からOleStr型へのバリアント型変換はできません」が出る不具合を修正した。
- DBツリーのフィルター機能で/と/でくくって正規表現を使用したとき、ストアドプロシージャや、その他のオブジェクトが列挙されない不具合を修正した。
- その他不具合修正


### Version 2.11.2 2015/08/30
- SQL Server で「結果セット最大行数」の設定が小さすぎる場合、SELECT時の取得列数まで小さくなる不具合を修正
- Windowsキーと下キーによる最小化が正しく動作しない不具合修正
- Windows 10 のタブレットモードで最大化されない不具合ほかWindows 10関連の不具合をいくつか修正
- ストアドプロシージャランチャで全角の ＃ などの記号がつかわれていた場合に正しく動作しない不具合を修正
- スクリプトエディタでエラーが発生時に内部の状態が不正になる不具合を修正
- ERエディタで保存を行うと、ドメインの中の「'」が正しく扱われない問題を修正。
- クエリーデザイナ画面でSQL Server で利用される、@形式のパラメータを正しく扱えるようにした。
- ストアドプロシージャランチャでBoolean型を引数または戻り値に持つプロシージャ（ファンクション）が扱えないことを、実行時に明示するようにした。
- SQLエディタの SetParameter疑似命令で負の値が使えない不具合を修正した
- SQLエディタで結果セットの比較機能を使った後、「比較の中止」ボタンが表示されつづける不具合を修正した
- クエリーデザイナ画面でパラメータを使用して実行できるように修正した
- メニューの[ツール]に登録されているスクリプトに(0)から(9)までのショートカットキーを設定した
- スクリプト機能で、A5Formオブジェクトにフォーム（タブ）をアクティブにする、activate()メソッドを追加した。
- ER図のリバース生成時にコメントにNULL文字（データベースのNULLではなくC言語などで'\0'の文字）が混じっていると、ER図ファイルがうまく読み込めず、次回保存時に壊れて保存される不具合を修正した。
- SQLエディタでinsert文のvalues句でのヒント(Ctrl+Shift+Spaceのヒント機能)でスキーマ名が付加されているとうまく動作しない不具合を修正した。
- Oracleでストアドプロシージャ・ランチャを使った際、引数が間違ってリストされることがある不具合を修正した。
- Oracleでストアドプロシージャ・ランチャで実行中に経過時間を正しく表示できない不具合を修正した。
- テーブルエディタで、日付型などで、NULL値のときに編集しようとすると、"1899/01/01"と表示されてしまう不具合修正
- PostgreSQLやMySQLで小文字のスキーマがあると、SQL入力支援でテーブルが列挙できなくなる不具合を修正
- グリッドからのコピー時、「HTML形式でコピーする」のオプションをOFFにしていると正しくコピーされない不具合を修正した。


### Version 2.11.1 2015/06/15
- 64bit版からIBM DB2への接続に失敗する不具合を修正
- SQL ServerのMONEY型を利用するOSの現地通貨型でなく単なるBCDとして扱うように変更
- ERエディタでSQLServerのDDLを出力する際、NULL可のtimestamp型で列属性に NULL を明示的にDDLに出力するようにした
- ERエディタのエンティティ定義書でビューに共通列が出力されてしまう不具合を修正
- データベースツリーの「最近開いたテーブル」からプロパティやソースが表示できない不具合を修正
- OracleでINSERT文で「カラム名を出力する」チェックをしてエクスポートするとエラーになる不具合を修正
- 通貨型を利用するOSの現地通貨型でなく、小数点以下２桁の実数表記に変更
- PostgreSQL へプロトコルバージョン 2.0 で接続した際に日本語を正しく扱えない不具合の修正
- SQLの結果セット比較でNULLのとき、他のExcel出力時と同様に「Zero Width SPace」を付加して出力するように修正
- ほか不具合修正


### Version 2.11.0 2015/03/15
- SQLエディタでReplace 疑似命令を実装
- ERエディタで、ER図全体のコメントを記述できるようにした
- Interbase/Firebirdの接続設定でキャラクタセットを指定可能にした
- 日付時刻・時刻型でミリ秒まで対応できるようにした(MySQL の timestamp(3) など)
- テーブルエディタのテストデータ作成機能で、日本人人名（姓・名・姓名）やemailアドレス、GUIDを生成できるようにした
- SQL整形で「カンマの位置」と「and, orの位置」を分けて指定できるようにした
- SQLエディタで簡易的にクロス集計出力(Excel)を実装
- レジストリやHDDに設定ファイル等を保存しないポータブルモードを実装
- 結果セットのコピーでHTMLフォーマットではなくプレーンテキストのみでのコピーも可能にした
- SQLエディタで、半角空白を薄い記号で表示できるようにした。
- SQLエディタでCtrl+ホイールでフォントサイズを変更できるように修正


### Version 2.10.1 2014/04/03
- 不具合修正


### Version 2.10.0 2014/03/06
- 接続ライブラリをdbExpressからUnidacに変更(Devart社製)
- ADOを使わなくても接続できるDB種別を大幅に増やす
  (Oracle, DB2, SQL Server, SQL Server Compact Edition, PostgreSQL, MySQL/MariaDB, Interbase/Firebird, SQLite, Access)
- IPv6対応
- TSV入出力対応
- SQL入力支援機能をPL/SQLに対応 
- Oracle限定で、プロシージャランチャからPL/SQLデバッグ実行ができるようになった
- Ctrl+Shift+Spaceでストアドプロシージャの引数リスト表示
- プロシージャランチャからソースの編集を行えるようにした
- テキストエディタで変換機能の追加
- ER図でページごとに背景色を変更する機能を追加


### Version 2.9.1 2013/08/19
- 不具合修正
- テーブルエディタで、トリガータブを追加し、トリガー情報を表示できるようにした（一部DBのみ）
- テーブル定義書の出力で、トリガー情報を出力できるようにした(Excel, HTML, 一部DBのみ)
- テーブル定義書CSVの出力で、トリガー情報を出力できるようにした(a5m2_TRIGGERS.csv, 一部DBのみ)


### Version 2.9.0 2013/06/19
- 全般的にSQLの非同期実行を見直し
- テーブル定義書の出力でビューも対応した。（ビューの場合はソースも出力）
- テーブルエディタで、「ソース」タブを新設した。
- ER図上のオブジェクトをDMonkeyスクリプトからアクセスできるようにした。
- ERエディタ機能の改良
- MySQL用のコントロールパネルを実装
- SQL Server, SQL Server Compactへの接続の改善
- SSH経由の接続でPuTTY形式の秘密鍵に対応（PLINK.exeが別途必要）
- 読み取り専用エディションを用意
- Wine 1.4, 1.5, 1.6(rc2)…での動作性の改善


### Version 2.8.1 2013/01/28
- ODBC接続時にエラーが発生する場合がある不具合を修正
- OracleでWITH句を使ったSQLのクエリーデザイナが正しく動作しない不具合を修正
- Oracleで複数列の外部キーがうまく取得できない不具合を修正
- ほか、不具合修正
- Windows Vista 以降の高DPI環境下の表示を改善


### Version 2.8.0 2012/10/21
- ERエディタ機能の機能向上
- Oracle(直接接続),PostgreSQL,MySQLでSSHトンネル経由の接続をサポート
- カラーユニバーサルデザイン(CUD)への取り組み


### Version 2.7.1 2012/06/03
- クエリーデザイナでテーブルの主キーや列の説明を表示するようにした。
- 定期的に新バージョンがないかチェックする機能を追加
- PostgreSQLの直接接続でポートがデフォルトポートしか接続出来なかった不具合を修正
- PostgreSQL 9.0 系でテーブルが列挙されない不具合を修正
- SQL入力支援でPostgreSQLの大文字混じりのテーブルの列が列挙できない不具合を修正
- Oracleでビューのソースの取得方法を変更(大きなソースを取得できない不具合修正)
- ERエディタでデータベースからの同期で失敗することがある不具合を修正
- テーブルエディタで固定長文字列を更新する時、後ろに空白文字列をFILLするように修正
- 結果セットをコピー(HTML)する時に、空白がトリムされたり、場合によってサニタイズが２回される不具合を修正
- テーブルエディタで主キーを誤って判断する不具合を修正
- ADO、ODBC以外の接続で、パスワード中に " や ; が含まれていた時にうまく接続出来なくなる不具合の修正


### Version 2.7.0 2012/03/01
- 従来のx86版に加え、x64版も用意
- ERエディタでサブタイプのサポート
- PostgreSQLへの直接接続をサポート
- HTML形式でのテーブル定義書やエンティティ定義書をサポート
- グリッドからのクリップボードへのコピーでHTML形式でコピーするように改良
- SQLエディタの構文入力支援でストアドプロシージャも列挙するようにした
- SQLエディタの構文入力支援のウインドウをリサイズ可能にした


### Version 2.6.3 2011/10/21
- SQLエディタの入力支援でアイコン表示に対応
- CSVのインポートで1024byteごとの境界で、日本語が化けてしまう不具合を修正(Shift_JIS, EUC-JP, JIS)
- ERエディタで表示レベルが正しく保存されないことがある不具合を修正
- Oracleのコントロールパネル機能で開いた直後に閉じるとエラーが発生する不具合を修正
- テーブルエディタでデータを表示しない状態でソートなどを選択するとエラーが発生する不具合を修正
- SQLの比較実行で実行対象のSQLが一つもなかった場合にエラーが発生する不具合を修正
- スキーマの比較機能で比較がうまくいかないことのある不具合を修正


### Version 2.6.2 2011/08/18
- MySQLでテーブルのコメント表示に対応
- MySQLでER図からDDLを作成時にテーブルコメントを生成するように修正
- SQL Server で ビューのコメントを表示出来るように修正（テーブルエディタ）
- MySQLでTEXT型の取得がうまくいっていなかった不具合を修正
　（これに関連し、更新がうまくいかないことがあった症状も改善）


### Version 2.6.1 2011/07/09
- ログイン時にトランザクション分離レベルの指定を可能にした
- SQLエディタでコメントアウト機能を '--' から '-- ' に変更した
- Oracleでデータベースリンクを表示するようにした
- テーブルエディタ・SQLエディタで、BLOB項目（CLOB項目を含む場合もあり）の表示に「16進表示」を追加
- ADO接続でない時にテーブルエディタ・SQLエディタのグリッドでデータを編集した時、エラーが表示されない不具合を修正
- MySQLでレプリケーション設定がされている時にテーブルエディタ・SQLエディタのグリッドでデータが編集できない不具合を修正


### Version 2.6.0 2011/06/01
- MySQLに対して、MySQL Connecter/ODBCの利用を不可能にした
　（Oracle社のプロプライエタリアプリケーションとGPLライブラリの見解に基づく対応）
- Oracle Database及びMySQLに対して独自ライブラリによる直接接続を可能とした
　（Oracle Databaseに関してはOCIによる接続も可能）
- MySQLでサーバー上の各データベースをスキーマとして扱えるようにした
- ERエディタの機能強化
　・エンティティの表示サイズを手動で変更可能に
　・リレーションシップの線をコの字型、逆コの字型に出来るようにした
- Oracle向けのコントロールパネル機能を実装
- SQL Sercerログイン時に「統合セキュリティ認証」を選択可能に
- SQLエディタの機能強化
　・検索時の正規表現
　・コメントアウト機能・コメントアウト解除機能
　・SQLの比較実行機能
　・複数結果セットをExcelへ出力する時の操作性を改善
　・行ジャンプ機能の実装
- スキーマ間のデータ転送機能の実装


### Version 2.5.1 2010/09/25
- ERエディタのDDL生成でDBへのコメント登録で「論理名」と「コメント」の組み合わせを選択できるように修正
- Oracle利用時にテーブルやオブジェクトの名前に "" (ダブルクォート)を付けるルールを若干変更
- SQL整形で、識別子に "" (ダブルクォート)を明示的に付ける設定にしていても付かない不具合を修正
- "$" 記号を標準SQL識別子の構成文字と見なしていた不具合を修正
- ERエディタのプロパティ画面でリサイズできるように修正


### Version 2.5.0 2010/06/23
- Unicode対応
- Unicode対応に伴い、テキストエディタコンポーネントをTEditorからTSyntaxEditへ切り替え
- コード構造ツリーを実装
- その他小機能追加


### Version 2.4.1 2010/04/03
- SQLServerにて主キーの順序が正しく取得できない（ER図のリバース生成など）不具合の修正
- BlobエディタでJPEGイメージが表示できない不具合の修正
- 自動列挙されたODBCデータソースで保存されたユーザーID＆パスワードでログインできない不具合の修正
- SQLエディタでSQL Serverの結果セットのあるINSERT, UPDATE, DELETE文（OUTPUT句）への対応
- SQL整形機能で BETWEEN 句の後ろに @マーク付きのパラメータがあった場合の動作修正


### Version 2.4.0 2010/03/07
- アイコンを変更
- データベースメタデータの扱いの変更（内部的なもの）
- データベースのテーブルやビューのプロパティおよびソースを表示可能にした
- SQLエディタでセミコロンの他にスラッシュのみの行でSQLを区切ることが出来るようにした
- 他SQLエディタ関係の機能追加
- テーブルやER図の情報をCSVとして出力できるようにした
- ER図でシェイプオブジェクトや、線、ビットマップを描けるようにした
- ER図でエンティティを複数のページに表示出来るようにした
- 他ER図関係の機能追加


### Version 2.3.4 2009/09/10
- 入力支援機能の高速化
- ERリバース時のリレーションシップの依存判定の不具合修正
- ER図の「画像としてコピー」のコピー範囲がおかしくなる不具合修正


### Version 2.3.3 2009/05/25
- より新しいバージョンのA5:SQL Mk-2で保存されたER図を開いたときに表示がおかしくならないように修正した
- ER図のリバース時にテーブルやカラムのコメントを正しく扱えない不具合を修正した
- MySQLの4.1以前でRDBMS固有の情報の取得でエラーが発生する不具合を修正した
- MySQLの4.1以前でカラムの論理名やデータ型・コメントを取得すると文字化けする不具合を修正した
- テーブル定義書・エンティティ定義書で、テーブル論理名に全角の括弧があった場合、リンクが正しく動作しない不具合を修正した
- 一括エクスポートで、大文字小文字混じりや、漢字交じりのテーブル名が正しく扱えていない不具合を修正した
- インポートで、大文字小文字混じりや、漢字交じりのテーブル名が正しく扱えていない不具合を修正した
- Oracleで ROLLUP, CUBE, GROUPING SETSを使ったSQLに対応した


### Version 2.3.2 2009/02/22
- 小文字（PostgreSQLの場合は大文字）や漢字を使ったスキーマがあった場合にテーブルエディタを開くことができない不具合を修正
- テーブルエディタで「再読み込み」したとき、ソート順を保持するようにした
- 読み取り専用でデータベースに接続しているとき、トランザクションを開始できないようにした
- テーブルエディタで「テーブルの編集開始時に自動的にトランザクションを開始する」オプションを追加した


### Version 2.3.1 2009/01/25
- 機能追加と不具合修正


### Version 2.3.0 2008/12/01
- GUIで、クエリーを作成・編集する機能を搭載
　（Active Database Software社製 Active Query Builder を利用）
- ERエディタの機能強化
　（A2サイズまで対応・UNDO/REDO対応・カラム色対応・エンティティグラデーション対応 etc...）
- 各データベースでの対応強化
　（MySQLやPostgreSQLでの外部キーの扱いなど）
- etc...


### Version 2.2.0 2008/03/16
- ER図機能の強化(B4, A3 縦長／横長対応・カラムにコメントを
追加可能・EMF形式でクリップボードへコピーなど)
- SQL入力支援の強化（カラム型名や論理名表示などを色つき
で表示）
- ER図とSQL編集機能の連携（ER図の登録されたデータベースで
論理名表示など）
- insert文入力支援機能搭載
- JavaScriptライクなスクリプト（DMonkey）搭載 


### Version 2.1.0 2007/07/15
- ER図作画機能（ERエディタ）搭載
- お気に入り機能の追加
- 履歴機能の追加
- SQL実行計画の表示機能追加
- タブの閉じるボタン実装・マウスドラッグによるタブの並べ替え
- テーブル定義書作成機能の追加
- 同期SQL実行する機能の追加 
- スキーマの比較機能
- UTF-8, EUC-JPへの対応（SQLファイル）
- テーブルエディタで絡むコメントを論理名として表示する機能の追加
- BLOBエディタで文字コードの指定を可能とした
- etc...


### Version 2.0.1 2007/03/04
- コンパイラの最適化オプションを有効にした。
- SQLエディタで「結果セットをExcelへ出力(1シート)」または
「結果セットをExcelへ出力(複数シート)」を選択した際、SQL
実行時にハングアップする不具合を解消した。
- SQLのメニューで「結果セットをExcelへ出力(xxxx)」を「結果
セットをExcelへ自動出力(xxxx)」に変更した。
- OracleでPUBLICなシノニムをテーブルエディタで開けるように
した。
- CreateやAlter文を実行した際、ステータスバーにメニューから
データベースの再読み込みを行うように促すメッセージを表示す
るようにした。


### Version 2.0 2007/02/17
- 最初のリリース
- あまのいわと５からのデータベース接続コンポーネントの切り替え
　（BDE→ADO）
- 結果セットの印刷機能を削除
- データディクショナリ機能を削除


## ■■■ 以下あまのいわと５世代の履歴 ■■■


### Version 1.2.0 2006/08/16
- 一括エクスポート／連続インポート機能搭載
- SQL入力支援機能の機能向上
- etc...


### Version 1.1.2 2006/04/27
- SQL入力支援機能の機能向上
- etc...


### Version 1.1.1 2006/03/29
- SQL入力支援機能の機能向上
- etc...


### Version 1.1.0 2006/01/17
- 複数の結果セットを一度にExcelへ出力する機能
- エディタ機能として TEditor を採用
- SQL入力支援機能搭載（Ctrl+Spaceにてテーブル名やカラム名を列挙）
- タブインターフェイスの採用
- SQL整形機能搭載（複数行化・１行化）
- etc...


### Version 1.0.6 2003/02/16 （Vector初公開バージョン）
- ツールバー導入
- 動作を Windows 2000/XPに最適化
- etc...


### Version 1.0.4 1999/11/16
- Excelでの出力
- 結果セットのフィルタリング
- 限定的にタイおよび中国へ輸出（勤務先関連会社の内部限定使用として）
- etc...


### Version 1.0.3 1999/09/12
- SQLファイル履歴機能
- 国際化対応（英語リソースを準備）
- etc...


### Version 1.0.2 1999/06/20
- データディクショナリ（テーブル名やカラム名に論理名を提供する機能）を追加
- Blobエディタ搭載
- 国際化対応（ただし言語リソースは日本語のみ）
- etc...


### Version 1.0 1998/08/13
- ヘルプを搭載
- etc...


Version 1.0β 1997/07/xx
- 最初の公開バージョン（勤務先社内での内部公開）
- テーブルエディタ／SQLエグゼキュータ／ストアドプロシージャランチャの実装
- OracleのSQL実行計画を取得する機能（隠し機能として）
- CSVの入出力
- 結果セットの印刷
- パラメータ機能
- etc...
